/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.MessageAggregationException;
import io.netty.handler.codec.MessageAggregator$1;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;

public abstract class MessageAggregator<I, S, C extends ByteBufHolder, O extends ByteBufHolder>
extends MessageToMessageDecoder<I> {
    private static final int DEFAULT_MAX_COMPOSITEBUFFER_COMPONENTS = 1024;
    private final int maxContentLength;
    private O currentMessage;
    private boolean handlingOversizedMessage;
    private int maxCumulationBufferComponents = 1024;
    private ChannelHandlerContext ctx;
    private ChannelFutureListener continueResponseWriteListener;

    protected MessageAggregator(int n2) {
        MessageAggregator.validateMaxContentLength(n2);
        this.maxContentLength = n2;
    }

    protected MessageAggregator(int n2, Class<? extends I> clazz) {
        super(clazz);
        MessageAggregator.validateMaxContentLength(n2);
        this.maxContentLength = n2;
    }

    private static void validateMaxContentLength(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maxContentLength: " + n2 + " (expected: >= 0)");
        }
    }

    @Override
    public boolean acceptInboundMessage(Object object) {
        if (!super.acceptInboundMessage(object)) {
            return false;
        }
        Object object2 = object;
        return (this.isContentMessage(object2) || this.isStartMessage(object2)) && !this.isAggregated(object2);
    }

    protected abstract boolean isStartMessage(I var1);

    protected abstract boolean isContentMessage(I var1);

    protected abstract boolean isLastContentMessage(C var1);

    protected abstract boolean isAggregated(I var1);

    public final int maxContentLength() {
        return this.maxContentLength;
    }

    public final int maxCumulationBufferComponents() {
        return this.maxCumulationBufferComponents;
    }

    public final void setMaxCumulationBufferComponents(int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException("maxCumulationBufferComponents: " + n2 + " (expected: >= 2)");
        }
        if (this.ctx != null) {
            throw new IllegalStateException("decoder properties cannot be changed once the decoder is added to a pipeline.");
        }
        this.maxCumulationBufferComponents = n2;
    }

    @Deprecated
    public final boolean isHandlingOversizedMessage() {
        return this.handlingOversizedMessage;
    }

    protected final ChannelHandlerContext ctx() {
        if (this.ctx == null) {
            throw new IllegalStateException("not added to a pipeline yet");
        }
        return this.ctx;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, I i2, List<Object> list) {
        if (this.isStartMessage(i2)) {
            Object object;
            this.handlingOversizedMessage = false;
            if (this.currentMessage != null) {
                this.currentMessage.release();
                this.currentMessage = null;
                throw new MessageAggregationException();
            }
            I i3 = i2;
            Object object2 = this.newContinueResponse(i3, this.maxContentLength, channelHandlerContext.pipeline());
            if (object2 != null) {
                object = this.continueResponseWriteListener;
                if (object == null) {
                    object = new MessageAggregator$1(this, channelHandlerContext);
                    this.continueResponseWriteListener = object;
                }
                boolean bl2 = this.closeAfterContinueResponse(object2);
                this.handlingOversizedMessage = this.ignoreContentAfterContinueResponse(object2);
                ChannelFuture channelFuture = channelHandlerContext.writeAndFlush(object2).addListener((GenericFutureListener<? extends Future<? super Void>>)object);
                if (bl2) {
                    channelFuture.addListener(ChannelFutureListener.CLOSE);
                    return;
                }
                if (this.handlingOversizedMessage) {
                    return;
                }
            } else if (this.isContentLengthInvalid(i3, this.maxContentLength)) {
                this.invokeHandleOversizedMessage(channelHandlerContext, i3);
                return;
            }
            if (i3 instanceof DecoderResultProvider && !((DecoderResultProvider)i3).decoderResult().isSuccess()) {
                object = i3 instanceof ByteBufHolder ? this.beginAggregation(i3, ((ByteBufHolder)i3).content().retain()) : this.beginAggregation(i3, Unpooled.EMPTY_BUFFER);
                this.finishAggregation(object);
                list.add(object);
                return;
            }
            object = channelHandlerContext.alloc().compositeBuffer(this.maxCumulationBufferComponents);
            if (i3 instanceof ByteBufHolder) {
                MessageAggregator.appendPartialContent((CompositeByteBuf)object, ((ByteBufHolder)i3).content());
            }
            this.currentMessage = this.beginAggregation(i3, (ByteBuf)object);
        } else if (this.isContentMessage(i2)) {
            boolean bl3;
            if (this.currentMessage == null) {
                return;
            }
            CompositeByteBuf compositeByteBuf = (CompositeByteBuf)this.currentMessage.content();
            ByteBufHolder byteBufHolder = (ByteBufHolder)i2;
            if (compositeByteBuf.readableBytes() > this.maxContentLength - byteBufHolder.content().readableBytes()) {
                O o2 = this.currentMessage;
                this.invokeHandleOversizedMessage(channelHandlerContext, o2);
                return;
            }
            MessageAggregator.appendPartialContent(compositeByteBuf, byteBufHolder.content());
            this.aggregate(this.currentMessage, byteBufHolder);
            if (byteBufHolder instanceof DecoderResultProvider) {
                DecoderResult decoderResult = ((DecoderResultProvider)((Object)byteBufHolder)).decoderResult();
                if (!decoderResult.isSuccess()) {
                    if (this.currentMessage instanceof DecoderResultProvider) {
                        ((DecoderResultProvider)this.currentMessage).setDecoderResult(DecoderResult.failure(decoderResult.cause()));
                    }
                    bl3 = true;
                } else {
                    bl3 = this.isLastContentMessage(byteBufHolder);
                }
            } else {
                bl3 = this.isLastContentMessage(byteBufHolder);
            }
            if (bl3) {
                this.finishAggregation(this.currentMessage);
                list.add(this.currentMessage);
                this.currentMessage = null;
            }
        } else {
            throw new MessageAggregationException();
        }
    }

    private static void appendPartialContent(CompositeByteBuf compositeByteBuf, ByteBuf byteBuf) {
        if (byteBuf.isReadable()) {
            compositeByteBuf.addComponent(true, byteBuf.retain());
        }
    }

    protected abstract boolean isContentLengthInvalid(S var1, int var2);

    protected abstract Object newContinueResponse(S var1, int var2, ChannelPipeline var3);

    protected abstract boolean closeAfterContinueResponse(Object var1);

    protected abstract boolean ignoreContentAfterContinueResponse(Object var1);

    protected abstract O beginAggregation(S var1, ByteBuf var2);

    protected void aggregate(O o2, C c2) {
    }

    protected void finishAggregation(O o2) {
    }

    private void invokeHandleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s2) {
        this.handlingOversizedMessage = true;
        this.currentMessage = null;
        try {
            this.handleOversizedMessage(channelHandlerContext, s2);
        }
        finally {
            ReferenceCountUtil.release(s2);
        }
    }

    protected void handleOversizedMessage(ChannelHandlerContext channelHandlerContext, S s2) {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("content length exceeded " + this.maxContentLength() + " bytes."));
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (this.currentMessage != null && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        try {
            super.channelInactive(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            super.handlerRemoved(channelHandlerContext);
        }
        finally {
            this.releaseCurrentMessage();
        }
    }

    private void releaseCurrentMessage() {
        if (this.currentMessage != null) {
            this.currentMessage.release();
            this.currentMessage = null;
            this.handlingOversizedMessage = false;
        }
    }
}

