/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ByteProcessor;
import java.util.List;

public class LineBasedFrameDecoder
extends ByteToMessageDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;
    private int discardedBytes;
    private int offset;

    public LineBasedFrameDecoder(int n2) {
        this(n2, true, false);
    }

    public LineBasedFrameDecoder(int n2, boolean bl2, boolean bl3) {
        this.maxLength = n2;
        this.failFast = bl3;
        this.stripDelimiter = bl2;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n2 = this.findEndOfLine(byteBuf);
        if (!this.discarding) {
            if (n2 >= 0) {
                ByteBuf byteBuf2;
                int n3;
                int n4 = n2 - byteBuf.readerIndex();
                int n5 = n3 = byteBuf.getByte(n2) == 13 ? 2 : 1;
                if (n4 > this.maxLength) {
                    byteBuf.readerIndex(n2 + n3);
                    this.fail(channelHandlerContext, n4);
                    return null;
                }
                if (this.stripDelimiter) {
                    byteBuf2 = byteBuf.readRetainedSlice(n4);
                    byteBuf.skipBytes(n3);
                } else {
                    byteBuf2 = byteBuf.readRetainedSlice(n4 + n3);
                }
                return byteBuf2;
            }
            int n6 = byteBuf.readableBytes();
            if (n6 > this.maxLength) {
                this.discardedBytes = n6;
                byteBuf.readerIndex(byteBuf.writerIndex());
                this.discarding = true;
                this.offset = 0;
                if (this.failFast) {
                    this.fail(channelHandlerContext, "over " + this.discardedBytes);
                }
            }
            return null;
        }
        if (n2 >= 0) {
            int n7 = this.discardedBytes + n2 - byteBuf.readerIndex();
            int n8 = byteBuf.getByte(n2) == 13 ? 2 : 1;
            byteBuf.readerIndex(n2 + n8);
            this.discardedBytes = 0;
            this.discarding = false;
            if (!this.failFast) {
                this.fail(channelHandlerContext, n7);
            }
        } else {
            this.discardedBytes += byteBuf.readableBytes();
            byteBuf.readerIndex(byteBuf.writerIndex());
        }
        return null;
    }

    private void fail(ChannelHandlerContext channelHandlerContext, int n2) {
        this.fail(channelHandlerContext, String.valueOf(n2));
    }

    private void fail(ChannelHandlerContext channelHandlerContext, String string) {
        channelHandlerContext.fireExceptionCaught(new TooLongFrameException("frame length (" + string + ") exceeds the allowed maximum (" + this.maxLength + ')'));
    }

    private int findEndOfLine(ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        int n3 = byteBuf.forEachByte(byteBuf.readerIndex() + this.offset, n2 - this.offset, ByteProcessor.FIND_LF);
        if (n3 >= 0) {
            this.offset = 0;
            if (n3 > 0 && byteBuf.getByte(n3 - 1) == 13) {
                --n3;
            }
        } else {
            this.offset = n2;
        }
        return n3;
    }
}

