/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler$Sharable;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;

@ChannelHandler$Sharable
public class LengthFieldPrepender
extends MessageToMessageEncoder<ByteBuf> {
    private final ByteOrder byteOrder;
    private final int lengthFieldLength;
    private final boolean lengthIncludesLengthFieldLength;
    private final int lengthAdjustment;

    public LengthFieldPrepender(int n2) {
        this(n2, false);
    }

    public LengthFieldPrepender(int n2, boolean bl2) {
        this(n2, 0, bl2);
    }

    public LengthFieldPrepender(int n2, int n3) {
        this(n2, n3, false);
    }

    public LengthFieldPrepender(int n2, int n3, boolean bl2) {
        this(ByteOrder.BIG_ENDIAN, n2, n3, bl2);
    }

    public LengthFieldPrepender(ByteOrder byteOrder, int n2, int n3, boolean bl2) {
        if (n2 != 1 && n2 != 2 && n2 != 3 && n2 != 4 && n2 != 8) {
            throw new IllegalArgumentException("lengthFieldLength must be either 1, 2, 3, 4, or 8: " + n2);
        }
        ObjectUtil.checkNotNull(byteOrder, "byteOrder");
        this.byteOrder = byteOrder;
        this.lengthFieldLength = n2;
        this.lengthIncludesLengthFieldLength = bl2;
        this.lengthAdjustment = n3;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n2 = byteBuf.readableBytes() + this.lengthAdjustment;
        if (this.lengthIncludesLengthFieldLength) {
            n2 += this.lengthFieldLength;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Adjusted frame length (" + n2 + ") is less than zero");
        }
        switch (this.lengthFieldLength) {
            case 1: {
                if (n2 >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + n2);
                }
                list.add(channelHandlerContext.alloc().buffer(1).order(this.byteOrder).writeByte((byte)n2));
                break;
            }
            case 2: {
                if (n2 >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + n2);
                }
                list.add(channelHandlerContext.alloc().buffer(2).order(this.byteOrder).writeShort((short)n2));
                break;
            }
            case 3: {
                if (n2 >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + n2);
                }
                list.add(channelHandlerContext.alloc().buffer(3).order(this.byteOrder).writeMedium(n2));
                break;
            }
            case 4: {
                list.add(channelHandlerContext.alloc().buffer(4).order(this.byteOrder).writeInt(n2));
                break;
            }
            case 8: {
                list.add(channelHandlerContext.alloc().buffer(8).order(this.byteOrder).writeLong(n2));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        list.add(byteBuf.retain());
    }
}

