/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import java.nio.ByteOrder;
import java.util.List;

public class LengthFieldBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteOrder byteOrder;
    private final int maxFrameLength;
    private final int lengthFieldOffset;
    private final int lengthFieldLength;
    private final int lengthFieldEndOffset;
    private final int lengthAdjustment;
    private final int initialBytesToStrip;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private long tooLongFrameLength;
    private long bytesToDiscard;

    public LengthFieldBasedFrameDecoder(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, 0);
    }

    public LengthFieldBasedFrameDecoder(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, true);
    }

    public LengthFieldBasedFrameDecoder(int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        this(ByteOrder.BIG_ENDIAN, n2, n3, n4, n5, n6, bl2);
    }

    public LengthFieldBasedFrameDecoder(ByteOrder byteOrder, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        if (byteOrder == null) {
            throw new NullPointerException("byteOrder");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxFrameLength must be a positive integer: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("lengthFieldOffset must be a non-negative integer: " + n3);
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("initialBytesToStrip must be a non-negative integer: " + n6);
        }
        if (n3 > n2 - n4) {
            throw new IllegalArgumentException("maxFrameLength (" + n2 + ") must be equal to or greater than lengthFieldOffset (" + n3 + ") + lengthFieldLength (" + n4 + ").");
        }
        this.byteOrder = byteOrder;
        this.maxFrameLength = n2;
        this.lengthFieldOffset = n3;
        this.lengthFieldLength = n4;
        this.lengthAdjustment = n5;
        this.lengthFieldEndOffset = n3 + n4;
        this.initialBytesToStrip = n6;
        this.failFast = bl2;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    private void discardingTooLongFrame(ByteBuf byteBuf) {
        long l2 = this.bytesToDiscard;
        int n2 = (int)Math.min(l2, (long)byteBuf.readableBytes());
        byteBuf.skipBytes(n2);
        this.bytesToDiscard = l2 -= (long)n2;
        this.failIfNecessary(false);
    }

    private static void failOnNegativeLengthField(ByteBuf byteBuf, long l2, int n2) {
        byteBuf.skipBytes(n2);
        throw new CorruptedFrameException("negative pre-adjustment length field: " + l2);
    }

    private static void failOnFrameLengthLessThanLengthFieldEndOffset(ByteBuf byteBuf, long l2, int n2) {
        byteBuf.skipBytes(n2);
        throw new CorruptedFrameException("Adjusted frame length (" + l2 + ") is less than lengthFieldEndOffset: " + n2);
    }

    private void exceededFrameLength(ByteBuf byteBuf, long l2) {
        long l3 = l2 - (long)byteBuf.readableBytes();
        this.tooLongFrameLength = l2;
        if (l3 < 0L) {
            byteBuf.skipBytes((int)l2);
        } else {
            this.discardingTooLongFrame = true;
            this.bytesToDiscard = l3;
            byteBuf.skipBytes(byteBuf.readableBytes());
        }
        this.failIfNecessary(true);
    }

    private static void failOnFrameLengthLessThanInitialBytesToStrip(ByteBuf byteBuf, long l2, int n2) {
        byteBuf.skipBytes((int)l2);
        throw new CorruptedFrameException("Adjusted frame length (" + l2 + ") is less than initialBytesToStrip: " + n2);
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.discardingTooLongFrame) {
            this.discardingTooLongFrame(byteBuf);
        }
        if (byteBuf.readableBytes() < this.lengthFieldEndOffset) {
            return null;
        }
        int n2 = byteBuf.readerIndex() + this.lengthFieldOffset;
        long l2 = this.getUnadjustedFrameLength(byteBuf, n2, this.lengthFieldLength, this.byteOrder);
        if (l2 < 0L) {
            LengthFieldBasedFrameDecoder.failOnNegativeLengthField(byteBuf, l2, this.lengthFieldEndOffset);
        }
        if ((l2 += (long)(this.lengthAdjustment + this.lengthFieldEndOffset)) < (long)this.lengthFieldEndOffset) {
            LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanLengthFieldEndOffset(byteBuf, l2, this.lengthFieldEndOffset);
        }
        if (l2 > (long)this.maxFrameLength) {
            this.exceededFrameLength(byteBuf, l2);
            return null;
        }
        int n3 = (int)l2;
        if (byteBuf.readableBytes() < n3) {
            return null;
        }
        if (this.initialBytesToStrip > n3) {
            LengthFieldBasedFrameDecoder.failOnFrameLengthLessThanInitialBytesToStrip(byteBuf, l2, this.initialBytesToStrip);
        }
        byteBuf.skipBytes(this.initialBytesToStrip);
        int n4 = byteBuf.readerIndex();
        int n5 = n3 - this.initialBytesToStrip;
        ByteBuf byteBuf2 = this.extractFrame(channelHandlerContext, byteBuf, n4, n5);
        byteBuf.readerIndex(n4 + n5);
        return byteBuf2;
    }

    protected long getUnadjustedFrameLength(ByteBuf byteBuf, int n2, int n3, ByteOrder byteOrder) {
        long l2;
        byteBuf = byteBuf.order(byteOrder);
        switch (n3) {
            case 1: {
                l2 = byteBuf.getUnsignedByte(n2);
                break;
            }
            case 2: {
                l2 = byteBuf.getUnsignedShort(n2);
                break;
            }
            case 3: {
                l2 = byteBuf.getUnsignedMedium(n2);
                break;
            }
            case 4: {
                l2 = byteBuf.getUnsignedInt(n2);
                break;
            }
            case 8: {
                l2 = byteBuf.getLong(n2);
                break;
            }
            default: {
                throw new DecoderException("unsupported lengthFieldLength: " + this.lengthFieldLength + " (expected: 1, 2, 3, 4, or 8)");
            }
        }
        return l2;
    }

    private void failIfNecessary(boolean bl2) {
        if (this.bytesToDiscard == 0L) {
            long l2 = this.tooLongFrameLength;
            this.tooLongFrameLength = 0L;
            this.discardingTooLongFrame = false;
            if (!this.failFast || bl2) {
                this.fail(l2);
            }
        } else if (this.failFast && bl2) {
            this.fail(this.tooLongFrameLength);
        }
    }

    protected ByteBuf extractFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, int n2, int n3) {
        return byteBuf.retainedSlice(n2, n3);
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("Adjusted frame length exceeds " + this.maxFrameLength + " - discarding");
    }
}

