/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils$1;
import io.netty.handler.codec.HeadersUtils$CharSequenceDelegatingStringSet;
import io.netty.handler.codec.HeadersUtils$StringEntryIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HeadersUtils {
    private HeadersUtils() {
    }

    public static <K, V> List<String> getAllAsString(Headers<K, V, ?> headers, K k2) {
        List<V> list = headers.getAll(k2);
        return new HeadersUtils$1(list);
    }

    public static <K, V> String getAsString(Headers<K, V, ?> headers, K k2) {
        V v2 = headers.get(k2);
        return v2 != null ? v2.toString() : null;
    }

    public static Iterator<Map.Entry<String, String>> iteratorAsString(Iterable<Map.Entry<CharSequence, CharSequence>> iterable) {
        return new HeadersUtils$StringEntryIterator(iterable.iterator());
    }

    public static <K, V> String toString(Class<?> clazz, Iterator<Map.Entry<K, V>> iterator, int n2) {
        String string = clazz.getSimpleName();
        if (n2 == 0) {
            return string + "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2 + n2 * 20).append(string).append('[');
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.append(']').toString();
    }

    public static Set<String> namesAsString(Headers<CharSequence, CharSequence, ?> headers) {
        return new HeadersUtils$CharSequenceDelegatingStringSet(headers.names());
    }
}

