/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    public DelimiterBasedFrameDecoder(int n2, ByteBuf byteBuf) {
        this(n2, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl2, ByteBuf byteBuf) {
        this(n2, bl2, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl2, boolean bl3, ByteBuf byteBuf) {
        this(n2, bl2, bl3, new ByteBuf[]{byteBuf.slice(byteBuf.readerIndex(), byteBuf.readableBytes())});
    }

    public DelimiterBasedFrameDecoder(int n2, ByteBuf ... byteBufArray) {
        this(n2, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl2, ByteBuf ... byteBufArray) {
        this(n2, bl2, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n2, boolean bl2, boolean bl3, ByteBuf ... byteBufArray) {
        DelimiterBasedFrameDecoder.validateMaxFrameLength(n2);
        if (byteBufArray == null) {
            throw new NullPointerException("delimiters");
        }
        if (byteBufArray.length == 0) {
            throw new IllegalArgumentException("empty delimiters");
        }
        if (DelimiterBasedFrameDecoder.isLineBased(byteBufArray) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(n2, bl2, bl3);
            this.delimiters = null;
        } else {
            this.delimiters = new ByteBuf[byteBufArray.length];
            for (int i2 = 0; i2 < byteBufArray.length; ++i2) {
                ByteBuf byteBuf = byteBufArray[i2];
                DelimiterBasedFrameDecoder.validateDelimiter(byteBuf);
                this.delimiters[i2] = byteBuf.slice(byteBuf.readerIndex(), byteBuf.readableBytes());
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = n2;
        this.stripDelimiter = bl2;
        this.failFast = bl3;
    }

    private static boolean isLineBased(ByteBuf[] byteBufArray) {
        if (byteBufArray.length != 2) {
            return false;
        }
        ByteBuf byteBuf = byteBufArray[0];
        ByteBuf byteBuf2 = byteBufArray[1];
        if (byteBuf.capacity() < byteBuf2.capacity()) {
            byteBuf = byteBufArray[1];
            byteBuf2 = byteBufArray[0];
        }
        return byteBuf.capacity() == 2 && byteBuf2.capacity() == 1 && byteBuf.getByte(0) == 13 && byteBuf.getByte(1) == 10 && byteBuf2.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return this.getClass() != DelimiterBasedFrameDecoder.class;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode(channelHandlerContext, byteBuf);
        }
        int n2 = Integer.MAX_VALUE;
        ByteBuf byteBuf2 = null;
        for (ByteBuf byteBuf3 : this.delimiters) {
            int n3 = DelimiterBasedFrameDecoder.indexOf(byteBuf, byteBuf3);
            if (n3 < 0 || n3 >= n2) continue;
            n2 = n3;
            byteBuf2 = byteBuf3;
        }
        if (byteBuf2 != null) {
            ByteBuf byteBuf4;
            int n4 = byteBuf2.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                byteBuf.skipBytes(n2 + n4);
                int n5 = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(n5);
                }
                return null;
            }
            if (n2 > this.maxFrameLength) {
                byteBuf.skipBytes(n2 + n4);
                this.fail(n2);
                return null;
            }
            if (this.stripDelimiter) {
                byteBuf4 = byteBuf.readRetainedSlice(n2);
                byteBuf.skipBytes(n4);
            } else {
                byteBuf4 = byteBuf.readRetainedSlice(n2 + n4);
            }
            return byteBuf4;
        }
        if (!this.discardingTooLongFrame) {
            if (byteBuf.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = byteBuf.readableBytes();
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    this.fail(this.tooLongFrameLength);
                }
            }
        } else {
            this.tooLongFrameLength += byteBuf.readableBytes();
            byteBuf.skipBytes(byteBuf.readableBytes());
        }
        return null;
    }

    private void fail(long l2) {
        if (l2 > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l2 + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        for (int i2 = byteBuf.readerIndex(); i2 < byteBuf.writerIndex(); ++i2) {
            int n2;
            int n3 = i2;
            for (n2 = 0; n2 < byteBuf2.capacity() && byteBuf.getByte(n3) == byteBuf2.getByte(n2); ++n2) {
                if (++n3 != byteBuf.writerIndex() || n2 == byteBuf2.capacity() - 1) continue;
                return -1;
            }
            if (n2 != byteBuf2.capacity()) continue;
            return i2 - byteBuf.readerIndex();
        }
        return -1;
    }

    private static void validateDelimiter(ByteBuf byteBuf) {
        if (byteBuf == null) {
            throw new NullPointerException("delimiter");
        }
        if (!byteBuf.isReadable()) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxFrameLength must be a positive integer: " + n2);
        }
    }
}

