/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DefaultHeaders$HeaderEntry;
import io.netty.handler.codec.DefaultHeaders$HeaderIterator;
import io.netty.handler.codec.DefaultHeaders$NameValidator;
import io.netty.handler.codec.DefaultHeaders$ValueIterator;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.HeadersUtils;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.HashingStrategy;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultHeaders<K, V, T extends Headers<K, V, T>>
implements Headers<K, V, T> {
    static final int HASH_CODE_SEED = -1028477387;
    private final DefaultHeaders$HeaderEntry<K, V>[] entries;
    protected final DefaultHeaders$HeaderEntry<K, V> head;
    private final byte hashMask;
    private final ValueConverter<V> valueConverter;
    private final DefaultHeaders$NameValidator<K> nameValidator;
    private final HashingStrategy<K> hashingStrategy;
    int size;

    public DefaultHeaders(ValueConverter<V> valueConverter) {
        this(HashingStrategy.JAVA_HASHER, valueConverter);
    }

    public DefaultHeaders(ValueConverter<V> valueConverter, DefaultHeaders$NameValidator<K> defaultHeaders$NameValidator) {
        this(HashingStrategy.JAVA_HASHER, valueConverter, defaultHeaders$NameValidator);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter) {
        this(hashingStrategy, valueConverter, DefaultHeaders$NameValidator.NOT_NULL);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, DefaultHeaders$NameValidator<K> defaultHeaders$NameValidator) {
        this(hashingStrategy, valueConverter, defaultHeaders$NameValidator, 16);
    }

    public DefaultHeaders(HashingStrategy<K> hashingStrategy, ValueConverter<V> valueConverter, DefaultHeaders$NameValidator<K> defaultHeaders$NameValidator, int n2) {
        this.valueConverter = ObjectUtil.checkNotNull(valueConverter, "valueConverter");
        this.nameValidator = ObjectUtil.checkNotNull(defaultHeaders$NameValidator, "nameValidator");
        this.hashingStrategy = ObjectUtil.checkNotNull(hashingStrategy, "nameHashingStrategy");
        this.entries = new DefaultHeaders$HeaderEntry[MathUtil.findNextPositivePowerOfTwo(Math.max(2, Math.min(n2, 128)))];
        this.hashMask = (byte)(this.entries.length - 1);
        this.head = new DefaultHeaders$HeaderEntry();
    }

    @Override
    public V get(K k2) {
        ObjectUtil.checkNotNull(k2, "name");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n3];
        V v2 = null;
        while (defaultHeaders$HeaderEntry != null) {
            if (defaultHeaders$HeaderEntry.hash == n2 && this.hashingStrategy.equals(k2, defaultHeaders$HeaderEntry.key)) {
                v2 = defaultHeaders$HeaderEntry.value;
            }
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.next;
        }
        return v2;
    }

    @Override
    public V get(K k2, V v2) {
        V v3 = this.get(k2);
        if (v3 == null) {
            return v2;
        }
        return v3;
    }

    @Override
    public V getAndRemove(K k2) {
        int n2 = this.hashingStrategy.hashCode(k2);
        return this.remove0(n2, this.index(n2), ObjectUtil.checkNotNull(k2, "name"));
    }

    @Override
    public V getAndRemove(K k2, V v2) {
        V v3 = this.getAndRemove(k2);
        if (v3 == null) {
            return v2;
        }
        return v3;
    }

    @Override
    public List<V> getAll(K k2) {
        ObjectUtil.checkNotNull(k2, "name");
        LinkedList<V> linkedList = new LinkedList<V>();
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n3];
        while (defaultHeaders$HeaderEntry != null) {
            if (defaultHeaders$HeaderEntry.hash == n2 && this.hashingStrategy.equals(k2, defaultHeaders$HeaderEntry.key)) {
                linkedList.addFirst(defaultHeaders$HeaderEntry.getValue());
            }
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.next;
        }
        return linkedList;
    }

    public Iterator<V> valueIterator(K k2) {
        return new DefaultHeaders$ValueIterator(this, k2);
    }

    @Override
    public List<V> getAllAndRemove(K k2) {
        List<V> list = this.getAll(k2);
        this.remove(k2);
        return list;
    }

    @Override
    public boolean contains(K k2) {
        return this.get(k2) != null;
    }

    @Override
    public boolean containsObject(K k2, Object object) {
        return this.contains(k2, this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value")));
    }

    @Override
    public boolean containsBoolean(K k2, boolean bl2) {
        return this.contains(k2, this.valueConverter.convertBoolean(bl2));
    }

    @Override
    public boolean containsByte(K k2, byte by2) {
        return this.contains(k2, this.valueConverter.convertByte(by2));
    }

    @Override
    public boolean containsChar(K k2, char c2) {
        return this.contains(k2, this.valueConverter.convertChar(c2));
    }

    @Override
    public boolean containsShort(K k2, short s2) {
        return this.contains(k2, this.valueConverter.convertShort(s2));
    }

    @Override
    public boolean containsInt(K k2, int n2) {
        return this.contains(k2, this.valueConverter.convertInt(n2));
    }

    @Override
    public boolean containsLong(K k2, long l2) {
        return this.contains(k2, this.valueConverter.convertLong(l2));
    }

    @Override
    public boolean containsFloat(K k2, float f2) {
        return this.contains(k2, this.valueConverter.convertFloat(f2));
    }

    @Override
    public boolean containsDouble(K k2, double d2) {
        return this.contains(k2, this.valueConverter.convertDouble(d2));
    }

    @Override
    public boolean containsTimeMillis(K k2, long l2) {
        return this.contains(k2, this.valueConverter.convertTimeMillis(l2));
    }

    @Override
    public boolean contains(K k2, V v2) {
        return this.contains(k2, v2, HashingStrategy.JAVA_HASHER);
    }

    public final boolean contains(K k2, V v2, HashingStrategy<? super V> hashingStrategy) {
        ObjectUtil.checkNotNull(k2, "name");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n3];
        while (defaultHeaders$HeaderEntry != null) {
            if (defaultHeaders$HeaderEntry.hash == n2 && this.hashingStrategy.equals(k2, defaultHeaders$HeaderEntry.key) && hashingStrategy.equals(v2, defaultHeaders$HeaderEntry.value)) {
                return true;
            }
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.next;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == this.head.after;
    }

    @Override
    public Set<K> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.size());
        DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry = this.head.after;
        while (defaultHeaders$HeaderEntry != this.head) {
            linkedHashSet.add(defaultHeaders$HeaderEntry.getKey());
            defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.after;
        }
        return linkedHashSet;
    }

    @Override
    public T add(K k2, V v2) {
        this.nameValidator.validateName(k2);
        ObjectUtil.checkNotNull(v2, "value");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.add0(n2, n3, k2, v2);
        return this.thisT();
    }

    @Override
    public T add(K k2, Iterable<? extends V> iterable) {
        this.nameValidator.validateName(k2);
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        for (V v2 : iterable) {
            this.add0(n2, n3, k2, v2);
        }
        return this.thisT();
    }

    @Override
    public T add(K k2, V ... VArray) {
        this.nameValidator.validateName(k2);
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        for (V v2 : VArray) {
            this.add0(n2, n3, k2, v2);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K k2, Object object) {
        return this.add(k2, this.valueConverter.convertObject(ObjectUtil.checkNotNull(object, "value")));
    }

    @Override
    public T addObject(K k2, Iterable<?> iterable) {
        for (Object obj : iterable) {
            this.addObject(k2, obj);
        }
        return this.thisT();
    }

    @Override
    public T addObject(K k2, Object ... objectArray) {
        for (Object object : objectArray) {
            this.addObject(k2, object);
        }
        return this.thisT();
    }

    @Override
    public T addInt(K k2, int n2) {
        return this.add(k2, this.valueConverter.convertInt(n2));
    }

    @Override
    public T addLong(K k2, long l2) {
        return this.add(k2, this.valueConverter.convertLong(l2));
    }

    @Override
    public T addDouble(K k2, double d2) {
        return this.add(k2, this.valueConverter.convertDouble(d2));
    }

    @Override
    public T addTimeMillis(K k2, long l2) {
        return this.add(k2, this.valueConverter.convertTimeMillis(l2));
    }

    @Override
    public T addChar(K k2, char c2) {
        return this.add(k2, this.valueConverter.convertChar(c2));
    }

    @Override
    public T addBoolean(K k2, boolean bl2) {
        return this.add(k2, this.valueConverter.convertBoolean(bl2));
    }

    @Override
    public T addFloat(K k2, float f2) {
        return this.add(k2, this.valueConverter.convertFloat(f2));
    }

    @Override
    public T addByte(K k2, byte by2) {
        return this.add(k2, this.valueConverter.convertByte(by2));
    }

    @Override
    public T addShort(K k2, short s2) {
        return this.add(k2, this.valueConverter.convertShort(s2));
    }

    @Override
    public T add(Headers<? extends K, ? extends V, ?> headers) {
        if (headers == this) {
            throw new IllegalArgumentException("can't add to itself.");
        }
        this.addImpl(headers);
        return this.thisT();
    }

    protected void addImpl(Headers<? extends K, ? extends V, ?> headers) {
        if (headers instanceof DefaultHeaders) {
            DefaultHeaders defaultHeaders = (DefaultHeaders)headers;
            DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry = defaultHeaders.head.after;
            if (defaultHeaders.hashingStrategy == this.hashingStrategy && defaultHeaders.nameValidator == this.nameValidator) {
                while (defaultHeaders$HeaderEntry != defaultHeaders.head) {
                    this.add0(defaultHeaders$HeaderEntry.hash, this.index(defaultHeaders$HeaderEntry.hash), defaultHeaders$HeaderEntry.key, defaultHeaders$HeaderEntry.value);
                    defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.after;
                }
            } else {
                while (defaultHeaders$HeaderEntry != defaultHeaders.head) {
                    this.add((K)defaultHeaders$HeaderEntry.key, (V)defaultHeaders$HeaderEntry.value);
                    defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry.after;
                }
            }
        } else {
            for (Map.Entry<K, V> entry : headers) {
                this.add(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public T set(K k2, V v2) {
        this.nameValidator.validateName(k2);
        ObjectUtil.checkNotNull(v2, "value");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        this.add0(n2, n3, k2, v2);
        return this.thisT();
    }

    @Override
    public T set(K k2, Iterable<? extends V> iterable) {
        this.nameValidator.validateName(k2);
        ObjectUtil.checkNotNull(iterable, "values");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        for (V v2 : iterable) {
            if (v2 == null) break;
            this.add0(n2, n3, k2, v2);
        }
        return this.thisT();
    }

    @Override
    public T set(K k2, V ... VArray) {
        this.nameValidator.validateName(k2);
        ObjectUtil.checkNotNull(VArray, "values");
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        for (V v2 : VArray) {
            if (v2 == null) break;
            this.add0(n2, n3, k2, v2);
        }
        return this.thisT();
    }

    @Override
    public T setObject(K k2, Object object) {
        ObjectUtil.checkNotNull(object, "value");
        V v2 = ObjectUtil.checkNotNull(this.valueConverter.convertObject(object), "convertedValue");
        return this.set(k2, v2);
    }

    @Override
    public T setObject(K k2, Iterable<?> iterable) {
        this.nameValidator.validateName(k2);
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        for (Object obj : iterable) {
            if (obj == null) break;
            this.add0(n2, n3, k2, this.valueConverter.convertObject(obj));
        }
        return this.thisT();
    }

    @Override
    public T setObject(K k2, Object ... objectArray) {
        this.nameValidator.validateName(k2);
        int n2 = this.hashingStrategy.hashCode(k2);
        int n3 = this.index(n2);
        this.remove0(n2, n3, k2);
        for (Object object : objectArray) {
            if (object == null) break;
            this.add0(n2, n3, k2, this.valueConverter.convertObject(object));
        }
        return this.thisT();
    }

    @Override
    public T setInt(K k2, int n2) {
        return this.set(k2, this.valueConverter.convertInt(n2));
    }

    @Override
    public T setLong(K k2, long l2) {
        return this.set(k2, this.valueConverter.convertLong(l2));
    }

    @Override
    public T setDouble(K k2, double d2) {
        return this.set(k2, this.valueConverter.convertDouble(d2));
    }

    @Override
    public T setTimeMillis(K k2, long l2) {
        return this.set(k2, this.valueConverter.convertTimeMillis(l2));
    }

    @Override
    public T setFloat(K k2, float f2) {
        return this.set(k2, this.valueConverter.convertFloat(f2));
    }

    @Override
    public T setChar(K k2, char c2) {
        return this.set(k2, this.valueConverter.convertChar(c2));
    }

    @Override
    public T setBoolean(K k2, boolean bl2) {
        return this.set(k2, this.valueConverter.convertBoolean(bl2));
    }

    @Override
    public T setByte(K k2, byte by2) {
        return this.set(k2, this.valueConverter.convertByte(by2));
    }

    @Override
    public T setShort(K k2, short s2) {
        return this.set(k2, this.valueConverter.convertShort(s2));
    }

    @Override
    public T set(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            this.clear();
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public T setAll(Headers<? extends K, ? extends V, ?> headers) {
        if (headers != this) {
            for (K k2 : headers.names()) {
                this.remove(k2);
            }
            this.addImpl(headers);
        }
        return this.thisT();
    }

    @Override
    public boolean remove(K k2) {
        return this.getAndRemove(k2) != null;
    }

    @Override
    public T clear() {
        Arrays.fill(this.entries, null);
        this.head.after = this.head;
        this.head.before = this.head.after;
        this.size = 0;
        return this.thisT();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new DefaultHeaders$HeaderIterator(this, null);
    }

    @Override
    public Boolean getBoolean(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean getBoolean(K k2, boolean bl2) {
        Boolean bl3 = this.getBoolean(k2);
        return bl3 != null ? bl3 : bl2;
    }

    @Override
    public Byte getByte(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Byte.valueOf(this.valueConverter.convertToByte(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public byte getByte(K k2, byte by2) {
        Byte by3 = this.getByte(k2);
        return by3 != null ? by3 : by2;
    }

    @Override
    public Character getChar(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Character.valueOf(this.valueConverter.convertToChar(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public char getChar(K k2, char c2) {
        Character c3 = this.getChar(k2);
        return c3 != null ? c3.charValue() : c2;
    }

    @Override
    public Short getShort(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Short.valueOf(this.valueConverter.convertToShort(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public short getShort(K k2, short s2) {
        Short s3 = this.getShort(k2);
        return s3 != null ? s3 : s2;
    }

    @Override
    public Integer getInt(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Integer.valueOf(this.valueConverter.convertToInt(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getInt(K k2, int n2) {
        Integer n3 = this.getInt(k2);
        return n3 != null ? n3 : n2;
    }

    @Override
    public Long getLong(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Long.valueOf(this.valueConverter.convertToLong(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getLong(K k2, long l2) {
        Long l3 = this.getLong(k2);
        return l3 != null ? l3 : l2;
    }

    @Override
    public Float getFloat(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Float.valueOf(this.valueConverter.convertToFloat(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public float getFloat(K k2, float f2) {
        Float f3 = this.getFloat(k2);
        return f3 != null ? f3.floatValue() : f2;
    }

    @Override
    public Double getDouble(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Double.valueOf(this.valueConverter.convertToDouble(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public double getDouble(K k2, double d2) {
        Double d3 = this.getDouble(k2);
        return d3 != null ? d3 : d2;
    }

    @Override
    public Long getTimeMillis(K k2) {
        V v2 = this.get(k2);
        try {
            return v2 != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getTimeMillis(K k2, long l2) {
        Long l3 = this.getTimeMillis(k2);
        return l3 != null ? l3 : l2;
    }

    @Override
    public Boolean getBooleanAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Boolean.valueOf(this.valueConverter.convertToBoolean(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public boolean getBooleanAndRemove(K k2, boolean bl2) {
        Boolean bl3 = this.getBooleanAndRemove(k2);
        return bl3 != null ? bl3 : bl2;
    }

    @Override
    public Byte getByteAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Byte.valueOf(this.valueConverter.convertToByte(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public byte getByteAndRemove(K k2, byte by2) {
        Byte by3 = this.getByteAndRemove(k2);
        return by3 != null ? by3 : by2;
    }

    @Override
    public Character getCharAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Character.valueOf(this.valueConverter.convertToChar(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public char getCharAndRemove(K k2, char c2) {
        Character c3 = this.getCharAndRemove(k2);
        return c3 != null ? c3.charValue() : c2;
    }

    @Override
    public Short getShortAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Short.valueOf(this.valueConverter.convertToShort(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public short getShortAndRemove(K k2, short s2) {
        Short s3 = this.getShortAndRemove(k2);
        return s3 != null ? s3 : s2;
    }

    @Override
    public Integer getIntAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Integer.valueOf(this.valueConverter.convertToInt(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getIntAndRemove(K k2, int n2) {
        Integer n3 = this.getIntAndRemove(k2);
        return n3 != null ? n3 : n2;
    }

    @Override
    public Long getLongAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Long.valueOf(this.valueConverter.convertToLong(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getLongAndRemove(K k2, long l2) {
        Long l3 = this.getLongAndRemove(k2);
        return l3 != null ? l3 : l2;
    }

    @Override
    public Float getFloatAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Float.valueOf(this.valueConverter.convertToFloat(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public float getFloatAndRemove(K k2, float f2) {
        Float f3 = this.getFloatAndRemove(k2);
        return f3 != null ? f3.floatValue() : f2;
    }

    @Override
    public Double getDoubleAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Double.valueOf(this.valueConverter.convertToDouble(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public double getDoubleAndRemove(K k2, double d2) {
        Double d3 = this.getDoubleAndRemove(k2);
        return d3 != null ? d3 : d2;
    }

    @Override
    public Long getTimeMillisAndRemove(K k2) {
        V v2 = this.getAndRemove(k2);
        try {
            return v2 != null ? Long.valueOf(this.valueConverter.convertToTimeMillis(v2)) : null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public long getTimeMillisAndRemove(K k2, long l2) {
        Long l3 = this.getTimeMillisAndRemove(k2);
        return l3 != null ? l3 : l2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Headers)) {
            return false;
        }
        return this.equals((Headers)object, HashingStrategy.JAVA_HASHER);
    }

    public int hashCode() {
        return this.hashCode(HashingStrategy.JAVA_HASHER);
    }

    public final boolean equals(Headers<K, V, ?> headers, HashingStrategy<V> hashingStrategy) {
        if (headers.size() != this.size()) {
            return false;
        }
        if (this == headers) {
            return true;
        }
        for (K k2 : this.names()) {
            List<V> list = headers.getAll(k2);
            List<V> list2 = this.getAll(k2);
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (hashingStrategy.equals(list.get(i2), list2.get(i2))) continue;
                return false;
            }
        }
        return true;
    }

    public final int hashCode(HashingStrategy<V> hashingStrategy) {
        int n2 = -1028477387;
        for (K k2 : this.names()) {
            n2 = 31 * n2 + this.hashingStrategy.hashCode(k2);
            List<V> list = this.getAll(k2);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                n2 = 31 * n2 + hashingStrategy.hashCode(list.get(i2));
            }
        }
        return n2;
    }

    public String toString() {
        return HeadersUtils.toString(this.getClass(), this.iterator(), this.size());
    }

    protected DefaultHeaders$HeaderEntry<K, V> newHeaderEntry(int n2, K k2, V v2, DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry) {
        return new DefaultHeaders$HeaderEntry<K, V>(n2, k2, v2, defaultHeaders$HeaderEntry, this.head);
    }

    protected ValueConverter<V> valueConverter() {
        return this.valueConverter;
    }

    private int index(int n2) {
        return n2 & this.hashMask;
    }

    private void add0(int n2, int n3, K k2, V v2) {
        this.entries[n3] = this.newHeaderEntry(n2, k2, v2, this.entries[n3]);
        ++this.size;
    }

    private V remove0(int n2, int n3, K k2) {
        DefaultHeaders$HeaderEntry<K, V> defaultHeaders$HeaderEntry = this.entries[n3];
        if (defaultHeaders$HeaderEntry == null) {
            return null;
        }
        V v2 = null;
        DefaultHeaders$HeaderEntry defaultHeaders$HeaderEntry2 = defaultHeaders$HeaderEntry.next;
        while (defaultHeaders$HeaderEntry2 != null) {
            if (defaultHeaders$HeaderEntry2.hash == n2 && this.hashingStrategy.equals(k2, defaultHeaders$HeaderEntry2.key)) {
                v2 = defaultHeaders$HeaderEntry2.value;
                defaultHeaders$HeaderEntry.next = defaultHeaders$HeaderEntry2.next;
                defaultHeaders$HeaderEntry2.remove();
                --this.size;
            } else {
                defaultHeaders$HeaderEntry = defaultHeaders$HeaderEntry2;
            }
            defaultHeaders$HeaderEntry2 = defaultHeaders$HeaderEntry.next;
        }
        defaultHeaders$HeaderEntry = this.entries[n3];
        if (defaultHeaders$HeaderEntry.hash == n2 && this.hashingStrategy.equals(k2, defaultHeaders$HeaderEntry.key)) {
            if (v2 == null) {
                v2 = defaultHeaders$HeaderEntry.value;
            }
            this.entries[n3] = defaultHeaders$HeaderEntry.next;
            defaultHeaders$HeaderEntry.remove();
            --this.size;
        }
        return v2;
    }

    private T thisT() {
        return (T)this;
    }

    public DefaultHeaders<K, V, T> copy() {
        DefaultHeaders<K, V, T> defaultHeaders = new DefaultHeaders<K, V, T>(this.hashingStrategy, this.valueConverter, this.nameValidator, this.entries.length);
        defaultHeaders.addImpl(this);
        return defaultHeaders;
    }

    static /* synthetic */ HashingStrategy access$100(DefaultHeaders defaultHeaders) {
        return defaultHeaders.hashingStrategy;
    }

    static /* synthetic */ DefaultHeaders$HeaderEntry[] access$200(DefaultHeaders defaultHeaders) {
        return defaultHeaders.entries;
    }

    static /* synthetic */ int access$300(DefaultHeaders defaultHeaders, int n2) {
        return defaultHeaders.index(n2);
    }
}

