/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DateFormatter$1;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateFormatter {
    private static final BitSet DELIMITERS;
    private static final String[] DAY_OF_WEEK_TO_SHORT_NAME;
    private static final String[] CALENDAR_MONTH_TO_SHORT_NAME;
    private static final FastThreadLocal<DateFormatter> INSTANCES;
    private final GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
    private final StringBuilder sb = new StringBuilder(29);
    private boolean timeFound;
    private int hours;
    private int minutes;
    private int seconds;
    private boolean dayOfMonthFound;
    private int dayOfMonth;
    private boolean monthFound;
    private int month;
    private boolean yearFound;
    private int year;

    public static Date parseHttpDate(CharSequence charSequence) {
        return DateFormatter.parseHttpDate(charSequence, 0, charSequence.length());
    }

    public static Date parseHttpDate(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 0) {
            return null;
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Can't have end < start");
        }
        if (n4 > 64) {
            throw new IllegalArgumentException("Can't parse more than 64 chars,looks like a user error or a malformed header");
        }
        return DateFormatter.formatter().parse0(ObjectUtil.checkNotNull(charSequence, "txt"), n2, n3);
    }

    public static String format(Date date) {
        return DateFormatter.formatter().format0(ObjectUtil.checkNotNull(date, "date"));
    }

    public static StringBuilder append(Date date, StringBuilder stringBuilder) {
        return DateFormatter.formatter().append0(ObjectUtil.checkNotNull(date, "date"), ObjectUtil.checkNotNull(stringBuilder, "sb"));
    }

    private static DateFormatter formatter() {
        DateFormatter dateFormatter = INSTANCES.get();
        dateFormatter.reset();
        return dateFormatter;
    }

    private static boolean isDelim(char c2) {
        return DELIMITERS.get(c2);
    }

    private static boolean isDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static int getNumericalValue(char c2) {
        return c2 - 48;
    }

    private DateFormatter() {
        this.reset();
    }

    public void reset() {
        this.timeFound = false;
        this.hours = -1;
        this.minutes = -1;
        this.seconds = -1;
        this.dayOfMonthFound = false;
        this.dayOfMonth = -1;
        this.monthFound = false;
        this.month = -1;
        this.yearFound = false;
        this.year = -1;
        this.cal.clear();
        this.sb.setLength(0);
    }

    private boolean tryParseTime(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 5 || n4 > 8) {
            return false;
        }
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (DateFormatter.isDigit(c2)) {
                n9 = n9 * 10 + DateFormatter.getNumericalValue(c2);
                if (++n10 <= 2) continue;
                return false;
            }
            if (c2 == ':') {
                if (n10 == 0) {
                    return false;
                }
                switch (n8) {
                    case 0: {
                        n5 = n9;
                        break;
                    }
                    case 1: {
                        n6 = n9;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                n9 = 0;
                ++n8;
                n10 = 0;
                continue;
            }
            return false;
        }
        if (n10 > 0) {
            n7 = n9;
        }
        if (n5 >= 0 && n6 >= 0 && n7 >= 0) {
            this.hours = n5;
            this.minutes = n6;
            this.seconds = n7;
            return true;
        }
        return false;
    }

    private boolean tryParseDayOfMonth(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 1) {
            char c2 = charSequence.charAt(n2);
            if (DateFormatter.isDigit(c2)) {
                this.dayOfMonth = DateFormatter.getNumericalValue(c2);
                return true;
            }
        } else if (n4 == 2) {
            char c3 = charSequence.charAt(n2);
            char c4 = charSequence.charAt(n2 + 1);
            if (DateFormatter.isDigit(c3) && DateFormatter.isDigit(c4)) {
                this.dayOfMonth = DateFormatter.getNumericalValue(c3) * 10 + DateFormatter.getNumericalValue(c4);
                return true;
            }
        }
        return false;
    }

    private static boolean matchMonth(String string, CharSequence charSequence, int n2) {
        return AsciiString.regionMatchesAscii(string, true, 0, charSequence, n2, 3);
    }

    private boolean tryParseMonth(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 != 3) {
            return false;
        }
        if (DateFormatter.matchMonth("Jan", charSequence, n2)) {
            this.month = 0;
        } else if (DateFormatter.matchMonth("Feb", charSequence, n2)) {
            this.month = 1;
        } else if (DateFormatter.matchMonth("Mar", charSequence, n2)) {
            this.month = 2;
        } else if (DateFormatter.matchMonth("Apr", charSequence, n2)) {
            this.month = 3;
        } else if (DateFormatter.matchMonth("May", charSequence, n2)) {
            this.month = 4;
        } else if (DateFormatter.matchMonth("Jun", charSequence, n2)) {
            this.month = 5;
        } else if (DateFormatter.matchMonth("Jul", charSequence, n2)) {
            this.month = 6;
        } else if (DateFormatter.matchMonth("Aug", charSequence, n2)) {
            this.month = 7;
        } else if (DateFormatter.matchMonth("Sep", charSequence, n2)) {
            this.month = 8;
        } else if (DateFormatter.matchMonth("Oct", charSequence, n2)) {
            this.month = 9;
        } else if (DateFormatter.matchMonth("Nov", charSequence, n2)) {
            this.month = 10;
        } else if (DateFormatter.matchMonth("Dec", charSequence, n2)) {
            this.month = 11;
        } else {
            return false;
        }
        return true;
    }

    private boolean tryParseYear(CharSequence charSequence, int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 == 2) {
            char c2 = charSequence.charAt(n2);
            char c3 = charSequence.charAt(n2 + 1);
            if (DateFormatter.isDigit(c2) && DateFormatter.isDigit(c3)) {
                this.year = DateFormatter.getNumericalValue(c2) * 10 + DateFormatter.getNumericalValue(c3);
                return true;
            }
        } else if (n4 == 4) {
            char c4 = charSequence.charAt(n2);
            char c5 = charSequence.charAt(n2 + 1);
            char c6 = charSequence.charAt(n2 + 2);
            char c7 = charSequence.charAt(n2 + 3);
            if (DateFormatter.isDigit(c4) && DateFormatter.isDigit(c5) && DateFormatter.isDigit(c6) && DateFormatter.isDigit(c7)) {
                this.year = DateFormatter.getNumericalValue(c4) * 1000 + DateFormatter.getNumericalValue(c5) * 100 + DateFormatter.getNumericalValue(c6) * 10 + DateFormatter.getNumericalValue(c7);
                return true;
            }
        }
        return false;
    }

    private boolean parseToken(CharSequence charSequence, int n2, int n3) {
        if (!this.timeFound) {
            this.timeFound = this.tryParseTime(charSequence, n2, n3);
            if (this.timeFound) {
                return this.dayOfMonthFound && this.monthFound && this.yearFound;
            }
        }
        if (!this.dayOfMonthFound) {
            this.dayOfMonthFound = this.tryParseDayOfMonth(charSequence, n2, n3);
            if (this.dayOfMonthFound) {
                return this.timeFound && this.monthFound && this.yearFound;
            }
        }
        if (!this.monthFound) {
            this.monthFound = this.tryParseMonth(charSequence, n2, n3);
            if (this.monthFound) {
                return this.timeFound && this.dayOfMonthFound && this.yearFound;
            }
        }
        if (!this.yearFound) {
            this.yearFound = this.tryParseYear(charSequence, n2, n3);
        }
        return this.timeFound && this.dayOfMonthFound && this.monthFound && this.yearFound;
    }

    private Date parse0(CharSequence charSequence, int n2, int n3) {
        boolean bl2 = this.parse1(charSequence, n2, n3);
        return bl2 && this.normalizeAndValidate() ? this.computeDate() : null;
    }

    private boolean parse1(CharSequence charSequence, int n2, int n3) {
        int n4 = -1;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (DateFormatter.isDelim(c2)) {
                if (n4 == -1) continue;
                if (this.parseToken(charSequence, n4, i2)) {
                    return true;
                }
                n4 = -1;
                continue;
            }
            if (n4 != -1) continue;
            n4 = i2;
        }
        return n4 != -1 && this.parseToken(charSequence, n4, charSequence.length());
    }

    private boolean normalizeAndValidate() {
        if (this.dayOfMonth < 1 || this.dayOfMonth > 31 || this.hours > 23 || this.minutes > 59 || this.seconds > 59) {
            return false;
        }
        if (this.year >= 70 && this.year <= 99) {
            this.year += 1900;
        } else if (this.year >= 0 && this.year < 70) {
            this.year += 2000;
        } else if (this.year < 1601) {
            return false;
        }
        return true;
    }

    private Date computeDate() {
        this.cal.set(5, this.dayOfMonth);
        this.cal.set(2, this.month);
        this.cal.set(1, this.year);
        this.cal.set(11, this.hours);
        this.cal.set(12, this.minutes);
        this.cal.set(13, this.seconds);
        return this.cal.getTime();
    }

    private String format0(Date date) {
        this.append0(date, this.sb);
        return this.sb.toString();
    }

    private StringBuilder append0(Date date, StringBuilder stringBuilder) {
        this.cal.setTime(date);
        stringBuilder.append(DAY_OF_WEEK_TO_SHORT_NAME[this.cal.get(7) - 1]).append(", ");
        stringBuilder.append(this.cal.get(5)).append(' ');
        stringBuilder.append(CALENDAR_MONTH_TO_SHORT_NAME[this.cal.get(2)]).append(' ');
        stringBuilder.append(this.cal.get(1)).append(' ');
        DateFormatter.appendZeroLeftPadded(this.cal.get(11), stringBuilder).append(':');
        DateFormatter.appendZeroLeftPadded(this.cal.get(12), stringBuilder).append(':');
        return DateFormatter.appendZeroLeftPadded(this.cal.get(13), stringBuilder).append(" GMT");
    }

    private static StringBuilder appendZeroLeftPadded(int n2, StringBuilder stringBuilder) {
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        return stringBuilder.append(n2);
    }

    /* synthetic */ DateFormatter(DateFormatter$1 dateFormatter$1) {
        this();
    }

    static {
        int n2;
        DELIMITERS = new BitSet();
        DELIMITERS.set(9);
        for (n2 = 32; n2 <= 47; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        for (n2 = 59; n2 <= 64; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        for (n2 = 91; n2 <= 96; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        for (n2 = 123; n2 <= 126; n2 = (int)((char)(n2 + 1))) {
            DELIMITERS.set(n2);
        }
        DAY_OF_WEEK_TO_SHORT_NAME = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        CALENDAR_MONTH_TO_SHORT_NAME = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        INSTANCES = new DateFormatter$1();
    }
}

