/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.CodecOutputList$1;
import io.netty.handler.codec.CodecOutputList$2;
import io.netty.handler.codec.CodecOutputList$CodecOutputListRecycler;
import io.netty.handler.codec.CodecOutputList$CodecOutputLists;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractList;
import java.util.RandomAccess;

final class CodecOutputList
extends AbstractList<Object>
implements RandomAccess {
    private static final CodecOutputList$CodecOutputListRecycler NOOP_RECYCLER = new CodecOutputList$1();
    private static final FastThreadLocal<CodecOutputList$CodecOutputLists> CODEC_OUTPUT_LISTS_POOL = new CodecOutputList$2();
    private final CodecOutputList$CodecOutputListRecycler recycler;
    private int size;
    private Object[] array;
    private boolean insertSinceRecycled;

    static CodecOutputList newInstance() {
        return CODEC_OUTPUT_LISTS_POOL.get().getOrCreate();
    }

    private CodecOutputList(CodecOutputList$CodecOutputListRecycler codecOutputList$CodecOutputListRecycler, int n2) {
        this.recycler = codecOutputList$CodecOutputListRecycler;
        this.array = new Object[n2];
    }

    @Override
    public Object get(int n2) {
        this.checkIndex(n2);
        return this.array[n2];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(Object object) {
        ObjectUtil.checkNotNull(object, "element");
        try {
            this.insert(this.size, object);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.expandArray();
            this.insert(this.size, object);
        }
        ++this.size;
        return true;
    }

    @Override
    public Object set(int n2, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n2);
        Object object2 = this.array[n2];
        this.insert(n2, object);
        return object2;
    }

    @Override
    public void add(int n2, Object object) {
        ObjectUtil.checkNotNull(object, "element");
        this.checkIndex(n2);
        if (this.size == this.array.length) {
            this.expandArray();
        }
        if (n2 != this.size - 1) {
            System.arraycopy(this.array, n2, this.array, n2 + 1, this.size - n2);
        }
        this.insert(n2, object);
        ++this.size;
    }

    @Override
    public Object remove(int n2) {
        this.checkIndex(n2);
        Object object = this.array[n2];
        int n3 = this.size - n2 - 1;
        if (n3 > 0) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, n3);
        }
        this.array[--this.size] = null;
        return object;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    boolean insertSinceRecycled() {
        return this.insertSinceRecycled;
    }

    void recycle() {
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.array[i2] = null;
        }
        this.size = 0;
        this.insertSinceRecycled = false;
        this.recycler.recycle(this);
    }

    Object getUnsafe(int n2) {
        return this.array[n2];
    }

    private void checkIndex(int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void insert(int n2, Object object) {
        this.array[n2] = object;
        this.insertSinceRecycled = true;
    }

    private void expandArray() {
        int n2 = this.array.length << 1;
        if (n2 < 0) {
            throw new OutOfMemoryError();
        }
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.array, 0, objectArray, 0, this.array.length);
        this.array = objectArray;
    }

    /* synthetic */ CodecOutputList(CodecOutputList$CodecOutputListRecycler codecOutputList$CodecOutputListRecycler, int n2, CodecOutputList$1 codecOutputList$1) {
        this(codecOutputList$CodecOutputListRecycler, n2);
    }

    static /* synthetic */ CodecOutputList$CodecOutputListRecycler access$100() {
        return NOOP_RECYCLER;
    }
}

