/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.handler.codec.ByteToMessageDecoder$1;
import io.netty.handler.codec.ByteToMessageDecoder$2;
import io.netty.handler.codec.ByteToMessageDecoder$Cumulator;
import io.netty.handler.codec.CodecOutputList;
import io.netty.handler.codec.DecoderException;
import io.netty.util.internal.StringUtil;
import java.util.List;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final ByteToMessageDecoder$Cumulator MERGE_CUMULATOR = new ByteToMessageDecoder$1();
    public static final ByteToMessageDecoder$Cumulator COMPOSITE_CUMULATOR = new ByteToMessageDecoder$2();
    private static final byte STATE_INIT = 0;
    private static final byte STATE_CALLING_CHILD_DECODE = 1;
    private static final byte STATE_HANDLER_REMOVED_PENDING = 2;
    ByteBuf cumulation;
    private ByteToMessageDecoder$Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean decodeWasNull;
    private boolean first;
    private byte decodeState = 0;
    private int discardAfterReads = 16;
    private int numReads;

    protected ByteToMessageDecoder() {
        this.ensureNotSharable();
    }

    public void setSingleDecode(boolean bl2) {
        this.singleDecode = bl2;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void setCumulator(ByteToMessageDecoder$Cumulator byteToMessageDecoder$Cumulator) {
        if (byteToMessageDecoder$Cumulator == null) {
            throw new NullPointerException("cumulator");
        }
        this.cumulator = byteToMessageDecoder$Cumulator;
    }

    public void setDiscardAfterReads(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("discardAfterReads must be > 0");
        }
        this.discardAfterReads = n2;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf byteBuf = this.cumulation;
        if (byteBuf != null) {
            this.cumulation = null;
            int n2 = byteBuf.readableBytes();
            if (n2 > 0) {
                ByteBuf byteBuf2 = byteBuf.readBytes(n2);
                byteBuf.release();
                channelHandlerContext.fireChannelRead(byteBuf2);
            } else {
                byteBuf.release();
            }
            this.numReads = 0;
            channelHandlerContext.fireChannelReadComplete();
        }
        this.handlerRemoved0(channelHandlerContext);
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (!(object instanceof ByteBuf)) {
            channelHandlerContext.fireChannelRead(object);
            return;
        }
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            ByteBuf byteBuf = (ByteBuf)object;
            this.first = this.cumulation == null;
            this.cumulation = this.first ? byteBuf : this.cumulator.cumulate(channelHandlerContext.alloc(), this.cumulation, byteBuf);
            this.callDecode(channelHandlerContext, this.cumulation, codecOutputList);
        }
        catch (DecoderException decoderException) {
            try {
                throw decoderException;
                catch (Exception exception) {
                    throw new DecoderException(exception);
                }
            }
            catch (Throwable throwable) {
                if (this.cumulation != null && !this.cumulation.isReadable()) {
                    this.numReads = 0;
                    this.cumulation.release();
                    this.cumulation = null;
                } else if (++this.numReads >= this.discardAfterReads) {
                    this.numReads = 0;
                    this.discardSomeReadBytes();
                }
                int n2 = codecOutputList.size();
                this.decodeWasNull = !codecOutputList.insertSinceRecycled();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n2);
                codecOutputList.recycle();
                throw throwable;
            }
        }
        if (this.cumulation != null && !this.cumulation.isReadable()) {
            this.numReads = 0;
            this.cumulation.release();
            this.cumulation = null;
        } else if (++this.numReads >= this.discardAfterReads) {
            this.numReads = 0;
            this.discardSomeReadBytes();
        }
        int n3 = codecOutputList.size();
        this.decodeWasNull = !codecOutputList.insertSinceRecycled();
        ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n3);
        codecOutputList.recycle();
        return;
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, List<Object> list, int n2) {
        if (list instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, (CodecOutputList)list, n2);
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                channelHandlerContext.fireChannelRead(list.get(i2));
            }
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i2));
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (this.decodeWasNull) {
            this.decodeWasNull = false;
            if (!channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.channelInputClosed(channelHandlerContext, true);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(channelHandlerContext, false);
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelInputClosed(ChannelHandlerContext channelHandlerContext, boolean bl2) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(channelHandlerContext, codecOutputList);
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int n2 = codecOutputList.size();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n2);
                if (n2 > 0) {
                    channelHandlerContext.fireChannelReadComplete();
                }
                if (bl2) {
                    channelHandlerContext.fireChannelInactive();
                }
            }
            finally {
                codecOutputList.recycle();
            }
        }
    }

    void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        if (this.cumulation != null) {
            this.callDecode(channelHandlerContext, this.cumulation, list);
            this.decodeLast(channelHandlerContext, this.cumulation, list);
        } else {
            this.decodeLast(channelHandlerContext, Unpooled.EMPTY_BUFFER, list);
        }
    }

    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            while (byteBuf.isReadable()) {
                int n2 = list.size();
                if (n2 > 0) {
                    ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, n2);
                    list.clear();
                    if (channelHandlerContext.isRemoved()) break;
                    n2 = 0;
                }
                int n3 = byteBuf.readableBytes();
                this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
                if (!channelHandlerContext.isRemoved()) {
                    if (n2 == list.size()) {
                        if (n3 != byteBuf.readableBytes()) continue;
                    } else {
                        if (n3 == byteBuf.readableBytes()) {
                            throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                        }
                        if (!this.isSingleDecode()) continue;
                    }
                }
                break;
            }
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void decodeRemovalReentryProtection(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        boolean bl2;
        this.decodeState = 1;
        try {
            this.decode(channelHandlerContext, byteBuf, list);
            bl2 = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean bl3 = this.decodeState == 2;
            this.decodeState = 0;
            if (bl3) {
                this.handlerRemoved(channelHandlerContext);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (bl2) {
            this.handlerRemoved(channelHandlerContext);
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
        }
    }

    static ByteBuf expandCumulation(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n2) {
        ByteBuf byteBuf2 = byteBuf;
        byteBuf = byteBufAllocator.buffer(byteBuf2.readableBytes() + n2);
        byteBuf.writeBytes(byteBuf2);
        byteBuf2.release();
        return byteBuf;
    }
}

