/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.AsciiHeadersEncoder$NewlineType;
import io.netty.handler.codec.AsciiHeadersEncoder$SeparatorType;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.Map;

public final class AsciiHeadersEncoder {
    private final ByteBuf buf;
    private final AsciiHeadersEncoder$SeparatorType separatorType;
    private final AsciiHeadersEncoder$NewlineType newlineType;

    public AsciiHeadersEncoder(ByteBuf byteBuf) {
        this(byteBuf, AsciiHeadersEncoder$SeparatorType.COLON_SPACE, AsciiHeadersEncoder$NewlineType.CRLF);
    }

    public AsciiHeadersEncoder(ByteBuf byteBuf, AsciiHeadersEncoder$SeparatorType asciiHeadersEncoder$SeparatorType, AsciiHeadersEncoder$NewlineType asciiHeadersEncoder$NewlineType) {
        if (byteBuf == null) {
            throw new NullPointerException("buf");
        }
        if (asciiHeadersEncoder$SeparatorType == null) {
            throw new NullPointerException("separatorType");
        }
        if (asciiHeadersEncoder$NewlineType == null) {
            throw new NullPointerException("newlineType");
        }
        this.buf = byteBuf;
        this.separatorType = asciiHeadersEncoder$SeparatorType;
        this.newlineType = asciiHeadersEncoder$NewlineType;
    }

    public void encode(Map.Entry<CharSequence, CharSequence> entry) {
        CharSequence charSequence = entry.getKey();
        CharSequence charSequence2 = entry.getValue();
        ByteBuf byteBuf = this.buf;
        int n2 = charSequence.length();
        int n3 = charSequence2.length();
        int n4 = n2 + n3 + 4;
        int n5 = byteBuf.writerIndex();
        byteBuf.ensureWritable(n4);
        AsciiHeadersEncoder.writeAscii(byteBuf, n5, charSequence);
        n5 += n2;
        switch (this.separatorType) {
            case COLON: {
                byteBuf.setByte(n5++, 58);
                break;
            }
            case COLON_SPACE: {
                byteBuf.setByte(n5++, 58);
                byteBuf.setByte(n5++, 32);
                break;
            }
            default: {
                throw new Error();
            }
        }
        AsciiHeadersEncoder.writeAscii(byteBuf, n5, charSequence2);
        n5 += n3;
        switch (this.newlineType) {
            case LF: {
                byteBuf.setByte(n5++, 10);
                break;
            }
            case CRLF: {
                byteBuf.setByte(n5++, 13);
                byteBuf.setByte(n5++, 10);
                break;
            }
            default: {
                throw new Error();
            }
        }
        byteBuf.writerIndex(n5);
    }

    private static void writeAscii(ByteBuf byteBuf, int n2, CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.copy((AsciiString)charSequence, 0, byteBuf, n2, charSequence.length());
        } else {
            byteBuf.setCharSequence(n2, charSequence, CharsetUtil.US_ASCII);
        }
    }
}

