/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.unix.FileDescriptor;
import io.netty.util.internal.ObjectUtil;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class SocketWritableByteChannel
implements WritableByteChannel {
    private final FileDescriptor fd;

    protected SocketWritableByteChannel(FileDescriptor fileDescriptor) {
        this.fd = ObjectUtil.checkNotNull(fileDescriptor, "fd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int write(ByteBuffer byteBuffer) {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        if (byteBuffer.isDirect()) {
            n2 = this.fd.write(byteBuffer, n3, byteBuffer.limit());
        } else {
            int n5 = n4 - n3;
            ByteBuf byteBuf = null;
            try {
                Object object;
                if (n5 == 0) {
                    byteBuf = Unpooled.EMPTY_BUFFER;
                } else {
                    object = this.alloc();
                    if (object.isDirectBufferPooled()) {
                        byteBuf = object.directBuffer(n5);
                    } else {
                        byteBuf = ByteBufUtil.threadLocalDirectBuffer();
                        if (byteBuf == null) {
                            byteBuf = Unpooled.directBuffer(n5);
                        }
                    }
                }
                byteBuf.writeBytes(byteBuffer.duplicate());
                object = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n5);
                n2 = this.fd.write((ByteBuffer)object, ((Buffer)object).position(), ((Buffer)object).limit());
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }
        if (n2 > 0) {
            byteBuffer.position(n3 + n2);
        }
        return n2;
    }

    @Override
    public final boolean isOpen() {
        return this.fd.isOpen();
    }

    @Override
    public final void close() {
        this.fd.close();
    }

    protected abstract ByteBufAllocator alloc();
}

