/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.ChannelException;
import io.netty.channel.unix.DatagramSocketAddress;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.Errors$NativeConnectException;
import io.netty.channel.unix.Errors$NativeIoException;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.LimitsStaticallyReferencedJniMethods;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.ThrowableUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicBoolean;

public class Socket
extends FileDescriptor {
    private static final ClosedChannelException SHUTDOWN_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "shutdown(..)");
    private static final ClosedChannelException SEND_TO_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "sendTo(..)");
    private static final ClosedChannelException SEND_TO_ADDRESS_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "sendToAddress(..)");
    private static final ClosedChannelException SEND_TO_ADDRESSES_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Socket.class, "sendToAddresses(..)");
    private static final Errors$NativeIoException SEND_TO_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:sendto", Errors.ERRNO_EPIPE_NEGATIVE), Socket.class, "sendTo(..)");
    private static final Errors$NativeIoException SEND_TO_ADDRESS_CONNECTION_RESET_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:sendto", Errors.ERRNO_EPIPE_NEGATIVE), Socket.class, "sendToAddress");
    private static final Errors$NativeIoException CONNECTION_RESET_EXCEPTION_SENDMSG = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:sendmsg", Errors.ERRNO_EPIPE_NEGATIVE), Socket.class, "sendToAddresses(..)");
    private static final Errors$NativeIoException CONNECTION_RESET_SHUTDOWN_EXCEPTION = ThrowableUtil.unknownStackTrace(Errors.newConnectionResetException("syscall:shutdown", Errors.ERRNO_ECONNRESET_NEGATIVE), Socket.class, "shutdown");
    private static final Errors$NativeConnectException FINISH_CONNECT_REFUSED_EXCEPTION = ThrowableUtil.unknownStackTrace(new Errors$NativeConnectException("syscall:getsockopt", Errors.ERROR_ECONNREFUSED_NEGATIVE), Socket.class, "finishConnect(..)");
    private static final Errors$NativeConnectException CONNECT_REFUSED_EXCEPTION = ThrowableUtil.unknownStackTrace(new Errors$NativeConnectException("syscall:connect", Errors.ERROR_ECONNREFUSED_NEGATIVE), Socket.class, "connect(..)");
    public static final int UDS_SUN_PATH_SIZE = LimitsStaticallyReferencedJniMethods.udsSunPathSize();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();

    public Socket(int n2) {
        super(n2);
    }

    public final void shutdown() {
        this.shutdown(true, true);
    }

    public final void shutdown(boolean bl2, boolean bl3) {
        int n2;
        int n3;
        do {
            if (Socket.isClosed(n3 = this.state)) {
                throw new ClosedChannelException();
            }
            n2 = n3;
            if (bl2 && !Socket.isInputShutdown(n2)) {
                n2 = Socket.inputShutdown(n2);
            }
            if (bl3 && !Socket.isOutputShutdown(n2)) {
                n2 = Socket.outputShutdown(n2);
            }
            if (n2 != n3) continue;
            return;
        } while (!this.casState(n3, n2));
        n3 = Socket.shutdown(this.fd, bl2, bl3);
        if (n3 < 0) {
            Errors.ioResult("shutdown", n3, CONNECTION_RESET_SHUTDOWN_EXCEPTION, SHUTDOWN_CLOSED_CHANNEL_EXCEPTION);
        }
    }

    public final boolean isShutdown() {
        int n2 = this.state;
        return Socket.isInputShutdown(n2) && Socket.isOutputShutdown(n2);
    }

    public final boolean isInputShutdown() {
        return Socket.isInputShutdown(this.state);
    }

    public final boolean isOutputShutdown() {
        return Socket.isOutputShutdown(this.state);
    }

    public final int sendTo(ByteBuffer byteBuffer, int n2, int n3, InetAddress inetAddress, int n4) {
        int n5;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n5 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n5 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n6 = Socket.sendTo(this.fd, byteBuffer, n2, n3, byArray, n5, n4);
        if (n6 >= 0) {
            return n6;
        }
        if (n6 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendTo failed");
        }
        return Errors.ioResult("sendTo", n6, SEND_TO_CONNECTION_RESET_EXCEPTION, SEND_TO_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int sendToAddress(long l2, int n2, int n3, InetAddress inetAddress, int n4) {
        int n5;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n5 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n5 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n6 = Socket.sendToAddress(this.fd, l2, n2, n3, byArray, n5, n4);
        if (n6 >= 0) {
            return n6;
        }
        if (n6 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddress failed");
        }
        return Errors.ioResult("sendToAddress", n6, SEND_TO_ADDRESS_CONNECTION_RESET_EXCEPTION, SEND_TO_ADDRESS_CLOSED_CHANNEL_EXCEPTION);
    }

    public final int sendToAddresses(long l2, int n2, InetAddress inetAddress, int n3) {
        int n4;
        byte[] byArray;
        if (inetAddress instanceof Inet6Address) {
            byArray = inetAddress.getAddress();
            n4 = ((Inet6Address)inetAddress).getScopeId();
        } else {
            n4 = 0;
            byArray = NativeInetAddress.ipv4MappedIpv6Address(inetAddress.getAddress());
        }
        int n5 = Socket.sendToAddresses(this.fd, l2, n2, byArray, n4, n3);
        if (n5 >= 0) {
            return n5;
        }
        if (n5 == Errors.ERROR_ECONNREFUSED_NEGATIVE) {
            throw new PortUnreachableException("sendToAddresses failed");
        }
        return Errors.ioResult("sendToAddresses", n5, CONNECTION_RESET_EXCEPTION_SENDMSG, SEND_TO_ADDRESSES_CLOSED_CHANNEL_EXCEPTION);
    }

    public final DatagramSocketAddress recvFrom(ByteBuffer byteBuffer, int n2, int n3) {
        return Socket.recvFrom(this.fd, byteBuffer, n2, n3);
    }

    public final DatagramSocketAddress recvFromAddress(long l2, int n2, int n3) {
        return Socket.recvFromAddress(this.fd, l2, n2, n3);
    }

    public final int recvFd() {
        int n2 = Socket.recvFd(this.fd);
        if (n2 > 0) {
            return n2;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == Errors.ERRNO_EAGAIN_NEGATIVE || n2 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        throw Errors.newIOException("recvFd", n2);
    }

    public final int sendFd(int n2) {
        int n3 = Socket.sendFd(this.fd, n2);
        if (n3 >= 0) {
            return n3;
        }
        if (n3 == Errors.ERRNO_EAGAIN_NEGATIVE || n3 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("sendFd", n3);
    }

    public final boolean connect(SocketAddress socketAddress) {
        int n2;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetSocketAddress.getAddress());
            n2 = Socket.connect(this.fd, nativeInetAddress.address, nativeInetAddress.scopeId, inetSocketAddress.getPort());
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddress = (DomainSocketAddress)socketAddress;
            n2 = Socket.connectDomainSocket(this.fd, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
        if (n2 < 0) {
            if (n2 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            Errors.throwConnectException("connect", CONNECT_REFUSED_EXCEPTION, n2);
        }
        return true;
    }

    public final boolean finishConnect() {
        int n2 = Socket.finishConnect(this.fd);
        if (n2 < 0) {
            if (n2 == Errors.ERRNO_EINPROGRESS_NEGATIVE) {
                return false;
            }
            Errors.throwConnectException("finishConnect", FINISH_CONNECT_REFUSED_EXCEPTION, n2);
        }
        return true;
    }

    public final void disconnect() {
        int n2 = Socket.disconnect(this.fd);
        if (n2 < 0) {
            Errors.throwConnectException("disconnect", FINISH_CONNECT_REFUSED_EXCEPTION, n2);
        }
    }

    public final void bind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetSocketAddress.getAddress());
            int n2 = Socket.bind(this.fd, nativeInetAddress.address, nativeInetAddress.scopeId, inetSocketAddress.getPort());
            if (n2 < 0) {
                throw Errors.newIOException("bind", n2);
            }
        } else if (socketAddress instanceof DomainSocketAddress) {
            DomainSocketAddress domainSocketAddress = (DomainSocketAddress)socketAddress;
            int n3 = Socket.bindDomainSocket(this.fd, domainSocketAddress.path().getBytes(CharsetUtil.UTF_8));
            if (n3 < 0) {
                throw Errors.newIOException("bind", n3);
            }
        } else {
            throw new Error("Unexpected SocketAddress implementation " + socketAddress);
        }
    }

    public final void listen(int n2) {
        int n3 = Socket.listen(this.fd, n2);
        if (n3 < 0) {
            throw Errors.newIOException("listen", n3);
        }
    }

    public final int accept(byte[] byArray) {
        int n2 = Socket.accept(this.fd, byArray);
        if (n2 >= 0) {
            return n2;
        }
        if (n2 == Errors.ERRNO_EAGAIN_NEGATIVE || n2 == Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
            return -1;
        }
        throw Errors.newIOException("accept", n2);
    }

    public final InetSocketAddress remoteAddress() {
        byte[] byArray = Socket.remoteAddress(this.fd);
        return byArray == null ? null : NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final InetSocketAddress localAddress() {
        byte[] byArray = Socket.localAddress(this.fd);
        return byArray == null ? null : NativeInetAddress.address(byArray, 0, byArray.length);
    }

    public final int getReceiveBufferSize() {
        return Socket.getReceiveBufferSize(this.fd);
    }

    public final int getSendBufferSize() {
        return Socket.getSendBufferSize(this.fd);
    }

    public final boolean isKeepAlive() {
        return Socket.isKeepAlive(this.fd) != 0;
    }

    public final boolean isTcpNoDelay() {
        return Socket.isTcpNoDelay(this.fd) != 0;
    }

    public final boolean isReuseAddress() {
        return Socket.isReuseAddress(this.fd) != 0;
    }

    public final boolean isReusePort() {
        return Socket.isReusePort(this.fd) != 0;
    }

    public final boolean isBroadcast() {
        return Socket.isBroadcast(this.fd) != 0;
    }

    public final int getSoLinger() {
        return Socket.getSoLinger(this.fd);
    }

    public final int getSoError() {
        return Socket.getSoError(this.fd);
    }

    public final int getTrafficClass() {
        return Socket.getTrafficClass(this.fd);
    }

    public final void setKeepAlive(boolean bl2) {
        Socket.setKeepAlive(this.fd, bl2 ? 1 : 0);
    }

    public final void setReceiveBufferSize(int n2) {
        Socket.setReceiveBufferSize(this.fd, n2);
    }

    public final void setSendBufferSize(int n2) {
        Socket.setSendBufferSize(this.fd, n2);
    }

    public final void setTcpNoDelay(boolean bl2) {
        Socket.setTcpNoDelay(this.fd, bl2 ? 1 : 0);
    }

    public final void setSoLinger(int n2) {
        Socket.setSoLinger(this.fd, n2);
    }

    public final void setReuseAddress(boolean bl2) {
        Socket.setReuseAddress(this.fd, bl2 ? 1 : 0);
    }

    public final void setReusePort(boolean bl2) {
        Socket.setReusePort(this.fd, bl2 ? 1 : 0);
    }

    public final void setBroadcast(boolean bl2) {
        Socket.setBroadcast(this.fd, bl2 ? 1 : 0);
    }

    public final void setTrafficClass(int n2) {
        Socket.setTrafficClass(this.fd, n2);
    }

    @Override
    public String toString() {
        return "Socket{fd=" + this.fd + '}';
    }

    public static Socket newSocketStream() {
        return new Socket(Socket.newSocketStream0());
    }

    public static Socket newSocketDgram() {
        return new Socket(Socket.newSocketDgram0());
    }

    public static Socket newSocketDomain() {
        return new Socket(Socket.newSocketDomain0());
    }

    public static void initialize() {
        if (INITIALIZED.compareAndSet(false, true)) {
            Socket.initialize(NetUtil.isIpV4StackPreferred());
        }
    }

    protected static int newSocketStream0() {
        int n2 = Socket.newSocketStreamFd();
        if (n2 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketStream", n2));
        }
        return n2;
    }

    protected static int newSocketDgram0() {
        int n2 = Socket.newSocketDgramFd();
        if (n2 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDgram", n2));
        }
        return n2;
    }

    protected static int newSocketDomain0() {
        int n2 = Socket.newSocketDomainFd();
        if (n2 < 0) {
            throw new ChannelException(Errors.newIOException("newSocketDomain", n2));
        }
        return n2;
    }

    private static native int shutdown(int var0, boolean var1, boolean var2);

    private static native int connect(int var0, byte[] var1, int var2, int var3);

    private static native int connectDomainSocket(int var0, byte[] var1);

    private static native int finishConnect(int var0);

    private static native int disconnect(int var0);

    private static native int bind(int var0, byte[] var1, int var2, int var3);

    private static native int bindDomainSocket(int var0, byte[] var1);

    private static native int listen(int var0, int var1);

    private static native int accept(int var0, byte[] var1);

    private static native byte[] remoteAddress(int var0);

    private static native byte[] localAddress(int var0);

    private static native int sendTo(int var0, ByteBuffer var1, int var2, int var3, byte[] var4, int var5, int var6);

    private static native int sendToAddress(int var0, long var1, int var3, int var4, byte[] var5, int var6, int var7);

    private static native int sendToAddresses(int var0, long var1, int var3, byte[] var4, int var5, int var6);

    private static native DatagramSocketAddress recvFrom(int var0, ByteBuffer var1, int var2, int var3);

    private static native DatagramSocketAddress recvFromAddress(int var0, long var1, int var3, int var4);

    private static native int recvFd(int var0);

    private static native int sendFd(int var0, int var1);

    private static native int newSocketStreamFd();

    private static native int newSocketDgramFd();

    private static native int newSocketDomainFd();

    private static native int isReuseAddress(int var0);

    private static native int isReusePort(int var0);

    private static native int getReceiveBufferSize(int var0);

    private static native int getSendBufferSize(int var0);

    private static native int isKeepAlive(int var0);

    private static native int isTcpNoDelay(int var0);

    private static native int isBroadcast(int var0);

    private static native int getSoLinger(int var0);

    private static native int getSoError(int var0);

    private static native int getTrafficClass(int var0);

    private static native void setReuseAddress(int var0, int var1);

    private static native void setReusePort(int var0, int var1);

    private static native void setKeepAlive(int var0, int var1);

    private static native void setReceiveBufferSize(int var0, int var1);

    private static native void setSendBufferSize(int var0, int var1);

    private static native void setTcpNoDelay(int var0, int var1);

    private static native void setSoLinger(int var0, int var1);

    private static native void setBroadcast(int var0, int var1);

    private static native void setTrafficClass(int var0, int var1);

    private static native void initialize(boolean var0);
}

