/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.util.internal.EmptyArrays;

public final class PeerCredentials {
    private final int pid;
    private final int uid;
    private final int[] gids;

    PeerCredentials(int n2, int n3, int ... nArray) {
        this.pid = n2;
        this.uid = n3;
        this.gids = nArray == null ? EmptyArrays.EMPTY_INTS : nArray;
    }

    public int pid() {
        return this.pid;
    }

    public int uid() {
        return this.uid;
    }

    public int[] gids() {
        return (int[])this.gids.clone();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("UserCredentials[pid=").append(this.pid).append("; uid=").append(this.uid).append("; gids=[");
        if (this.gids.length > 0) {
            stringBuilder.append(this.gids[0]);
            for (int i2 = 1; i2 < this.gids.length; ++i2) {
                stringBuilder.append(", ").append(this.gids[i2]);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

