/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

public final class IovArray
implements ChannelOutboundBuffer$MessageProcessor {
    private static final int ADDRESS_SIZE = PlatformDependent.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this.memoryAddress = PlatformDependent.allocateMemory(CAPACITY);
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    public boolean add(ByteBuf byteBuf) {
        ByteBuffer[] byteBufferArray;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        if (byteBuf.hasMemoryAddress() && byteBuf.nioBufferCount() == 1) {
            int n2 = byteBuf.readableBytes();
            return n2 == 0 || this.add(byteBuf.memoryAddress(), byteBuf.readerIndex(), n2);
        }
        for (ByteBuffer byteBuffer : byteBufferArray = byteBuf.nioBuffers()) {
            int n3 = byteBuffer.remaining();
            if (n3 == 0 || this.add(PlatformDependent.directBufferAddress(byteBuffer), byteBuffer.position(), n3) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long l2, int n2, int n3) {
        long l3 = this.memoryAddress(this.count);
        long l4 = l3 + (long)ADDRESS_SIZE;
        if (this.maxBytes - (long)n3 < this.size && this.count > 0) {
            return false;
        }
        this.size += (long)n3;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            PlatformDependent.putLong(l3, l2 + (long)n2);
            PlatformDependent.putLong(l4, n3);
        } else {
            assert (ADDRESS_SIZE == 4);
            PlatformDependent.putInt(l3, (int)l2 + n2);
            PlatformDependent.putInt(l4, n3);
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long l2) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive(l2, "maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int n2) {
        return this.memoryAddress + (long)(IOV_SIZE * n2);
    }

    public void release() {
        PlatformDependent.freeMemory(this.memoryAddress);
    }

    @Override
    public boolean processMessage(Object object) {
        return object instanceof ByteBuf && this.add((ByteBuf)object);
    }
}

