/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.channel.unix.Errors$NativeConnectException;
import io.netty.channel.unix.Errors$NativeIoException;
import io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import io.netty.util.internal.EmptyArrays;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;

public final class Errors {
    public static final int ERRNO_ENOENT_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOENT();
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    public static final int ERROR_ECONNREFUSED_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorECONNREFUSED();
    public static final int ERROR_EISCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEISCONN();
    public static final int ERROR_EALREADY_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEALREADY();
    public static final int ERROR_ENETUNREACH_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorENETUNREACH();
    private static final String[] ERRORS = new String[512];

    static void throwConnectException(String string, Errors$NativeConnectException errors$NativeConnectException, int n2) {
        if (n2 == errors$NativeConnectException.expectedErr()) {
            throw errors$NativeConnectException;
        }
        if (n2 == ERROR_EALREADY_NEGATIVE) {
            throw new ConnectionPendingException();
        }
        if (n2 == ERROR_ENETUNREACH_NEGATIVE) {
            throw new NoRouteToHostException();
        }
        if (n2 == ERROR_EISCONN_NEGATIVE) {
            throw new AlreadyConnectedException();
        }
        if (n2 == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw new ConnectException(string + "(..) failed: " + ERRORS[-n2]);
    }

    public static Errors$NativeIoException newConnectionResetException(String string, int n2) {
        Errors$NativeIoException errors$NativeIoException = Errors.newIOException(string, n2);
        errors$NativeIoException.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return errors$NativeIoException;
    }

    public static Errors$NativeIoException newIOException(String string, int n2) {
        return new Errors$NativeIoException(string, n2);
    }

    public static int ioResult(String string, int n2, Errors$NativeIoException errors$NativeIoException, ClosedChannelException closedChannelException) {
        if (n2 == ERRNO_EAGAIN_NEGATIVE || n2 == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n2 == errors$NativeIoException.expectedErr()) {
            throw errors$NativeIoException;
        }
        if (n2 == ERRNO_EBADF_NEGATIVE) {
            throw closedChannelException;
        }
        if (n2 == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (n2 == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw Errors.newIOException(string, n2);
    }

    private Errors() {
    }

    static /* synthetic */ String[] access$000() {
        return ERRORS;
    }

    static {
        for (int i2 = 0; i2 < ERRORS.length; ++i2) {
            Errors.ERRORS[i2] = ErrorsStaticallyReferencedJniMethods.strError(i2);
        }
    }
}

