/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.DefaultSocketChannelConfig;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannelConfig;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;

public class DefaultOioSocketChannelConfig
extends DefaultSocketChannelConfig
implements OioSocketChannelConfig {
    @Deprecated
    public DefaultOioSocketChannelConfig(SocketChannel socketChannel, Socket socket) {
        super(socketChannel, socket);
        this.setAllocator(new PreferHeapByteBufAllocator(this.getAllocator()));
    }

    DefaultOioSocketChannelConfig(OioSocketChannel oioSocketChannel, Socket socket) {
        super(oioSocketChannel, socket);
        this.setAllocator(new PreferHeapByteBufAllocator(this.getAllocator()));
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_TIMEOUT);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_TIMEOUT) {
            return (T)Integer.valueOf(this.getSoTimeout());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption != ChannelOption.SO_TIMEOUT) {
            return super.setOption(channelOption, t2);
        }
        this.setSoTimeout((Integer)t2);
        return true;
    }

    @Override
    public OioSocketChannelConfig setSoTimeout(int n2) {
        try {
            this.javaSocket.setSoTimeout(n2);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    @Override
    public int getSoTimeout() {
        try {
            return this.javaSocket.getSoTimeout();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public OioSocketChannelConfig setTcpNoDelay(boolean bl2) {
        super.setTcpNoDelay(bl2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setSoLinger(int n2) {
        super.setSoLinger(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setSendBufferSize(int n2) {
        super.setSendBufferSize(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setReceiveBufferSize(int n2) {
        super.setReceiveBufferSize(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setKeepAlive(boolean bl2) {
        super.setKeepAlive(bl2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setTrafficClass(int n2) {
        super.setTrafficClass(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setReuseAddress(boolean bl2) {
        super.setReuseAddress(bl2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setPerformancePreferences(int n2, int n3, int n4) {
        super.setPerformancePreferences(n2, n3, n4);
        return this;
    }

    @Override
    public OioSocketChannelConfig setAllowHalfClosure(boolean bl2) {
        super.setAllowHalfClosure(bl2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    @Deprecated
    public OioSocketChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public OioSocketChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public OioSocketChannelConfig setAutoRead(boolean bl2) {
        super.setAutoRead(bl2);
        return this;
    }

    @Override
    protected void autoReadCleared() {
        if (this.channel instanceof OioSocketChannel) {
            ((OioSocketChannel)this.channel).clearReadPending0();
        }
    }

    @Override
    public OioSocketChannelConfig setAutoClose(boolean bl2) {
        super.setAutoClose(bl2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public OioSocketChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public OioSocketChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }
}

