/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp.oio;

import com.sun.nio.sctp.SctpChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.oio.AbstractOioMessageChannel;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.SctpServerChannelConfig;
import io.netty.channel.sctp.oio.OioSctpChannel;
import io.netty.channel.sctp.oio.OioSctpServerChannel$1;
import io.netty.channel.sctp.oio.OioSctpServerChannel$2;
import io.netty.channel.sctp.oio.OioSctpServerChannel$OioSctpServerChannelConfig;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OioSctpServerChannel
extends AbstractOioMessageChannel
implements SctpServerChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(OioSctpServerChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 1);
    private final com.sun.nio.sctp.SctpServerChannel sch;
    private final SctpServerChannelConfig config;
    private final Selector selector;

    private static com.sun.nio.sctp.SctpServerChannel newServerSocket() {
        try {
            return com.sun.nio.sctp.SctpServerChannel.open();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to create a sctp server channel", iOException);
        }
    }

    public OioSctpServerChannel() {
        this(OioSctpServerChannel.newServerSocket());
    }

    public OioSctpServerChannel(com.sun.nio.sctp.SctpServerChannel sctpServerChannel) {
        super(null);
        if (sctpServerChannel == null) {
            throw new NullPointerException("sctp server channel");
        }
        this.sch = sctpServerChannel;
        boolean bl2 = false;
        try {
            sctpServerChannel.configureBlocking(false);
            this.selector = Selector.open();
            sctpServerChannel.register(this.selector, 16);
            this.config = new OioSctpServerChannel$OioSctpServerChannelConfig(this, this, sctpServerChannel);
            bl2 = true;
        }
        catch (Exception exception) {
            throw new ChannelException("failed to initialize a sctp server channel", exception);
        }
        finally {
            if (!bl2) {
                try {
                    sctpServerChannel.close();
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close a sctp server channel.", iOException);
                }
            }
        }
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SctpServerChannelConfig config() {
        return this.config;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public boolean isOpen() {
        return this.sch.isOpen();
    }

    @Override
    protected SocketAddress localAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.sch.getAllLocalAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<InetSocketAddress> allLocalAddresses() {
        try {
            Set<SocketAddress> set = this.sch.getAllLocalAddresses();
            LinkedHashSet<InetSocketAddress> linkedHashSet = new LinkedHashSet<InetSocketAddress>(set.size());
            for (SocketAddress socketAddress : set) {
                linkedHashSet.add((InetSocketAddress)socketAddress);
            }
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.localAddress0() != null;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.sch.bind(socketAddress, this.config.getBacklog());
    }

    @Override
    protected void doClose() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
        this.sch.close();
    }

    @Override
    protected int doReadMessages(List<Object> list) {
        int n2;
        block7: {
            if (!this.isActive()) {
                return -1;
            }
            AbstractInterruptibleChannel abstractInterruptibleChannel = null;
            n2 = 0;
            try {
                int n3 = this.selector.select(1000L);
                if (n3 > 0) {
                    Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                    do {
                        SelectionKey selectionKey = iterator.next();
                        iterator.remove();
                        if (!selectionKey.isAcceptable() || (abstractInterruptibleChannel = this.sch.accept()) == null) continue;
                        list.add(new OioSctpChannel((Channel)this, (SctpChannel)abstractInterruptibleChannel));
                        ++n2;
                    } while (iterator.hasNext());
                    return n2;
                }
            }
            catch (Throwable throwable) {
                logger.warn("Failed to create a new channel from an accepted sctp channel.", throwable);
                if (abstractInterruptibleChannel == null) break block7;
                try {
                    abstractInterruptibleChannel.close();
                }
                catch (Throwable throwable2) {
                    logger.warn("Failed to close a sctp channel.", throwable2);
                }
            }
        }
        return n2;
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress) {
        return this.bindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.sch.bindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new OioSctpServerChannel$1(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress) {
        return this.unbindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.sch.unbindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new OioSctpServerChannel$2(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    protected void doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    static /* synthetic */ void access$100(OioSctpServerChannel oioSctpServerChannel) {
        oioSctpServerChannel.clearReadPending();
    }
}

