/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp.nio;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.RecvByteBufAllocator$Handle;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpChannelConfig;
import io.netty.channel.sctp.SctpMessage;
import io.netty.channel.sctp.SctpNotificationHandler;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.nio.NioSctpChannel$1;
import io.netty.channel.sctp.nio.NioSctpChannel$2;
import io.netty.channel.sctp.nio.NioSctpChannel$NioSctpChannelConfig;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class NioSctpChannel
extends AbstractNioMessageChannel
implements SctpChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioSctpChannel.class);
    private final SctpChannelConfig config;
    private final NotificationHandler<?> notificationHandler;

    private static com.sun.nio.sctp.SctpChannel newSctpChannel() {
        try {
            return com.sun.nio.sctp.SctpChannel.open();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a sctp channel.", iOException);
        }
    }

    public NioSctpChannel() {
        this(NioSctpChannel.newSctpChannel());
    }

    public NioSctpChannel(com.sun.nio.sctp.SctpChannel sctpChannel) {
        this(null, sctpChannel);
    }

    public NioSctpChannel(Channel channel, com.sun.nio.sctp.SctpChannel sctpChannel) {
        super(channel, sctpChannel, 1);
        try {
            sctpChannel.configureBlocking(false);
            this.config = new NioSctpChannel$NioSctpChannelConfig(this, this, sctpChannel, null);
            this.notificationHandler = new SctpNotificationHandler(this);
        }
        catch (IOException iOException) {
            block4: {
                try {
                    sctpChannel.close();
                }
                catch (IOException iOException2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to close a partially initialized sctp channel.", iOException2);
                }
            }
            throw new ChannelException("Failed to enter non-blocking mode.", iOException);
        }
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public SctpServerChannel parent() {
        return (SctpServerChannel)super.parent();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public Association association() {
        try {
            return this.javaChannel().association();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Set<InetSocketAddress> allLocalAddresses() {
        try {
            Set<SocketAddress> set = this.javaChannel().getAllLocalAddresses();
            LinkedHashSet<InetSocketAddress> linkedHashSet = new LinkedHashSet<InetSocketAddress>(set.size());
            for (SocketAddress socketAddress : set) {
                linkedHashSet.add((InetSocketAddress)socketAddress);
            }
            return linkedHashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    public SctpChannelConfig config() {
        return this.config;
    }

    @Override
    public Set<InetSocketAddress> allRemoteAddresses() {
        try {
            Set<SocketAddress> set = this.javaChannel().getRemoteAddresses();
            HashSet<InetSocketAddress> hashSet = new HashSet<InetSocketAddress>(set.size());
            for (SocketAddress socketAddress : set) {
                hashSet.add((InetSocketAddress)socketAddress);
            }
            return hashSet;
        }
        catch (Throwable throwable) {
            return Collections.emptySet();
        }
    }

    @Override
    protected com.sun.nio.sctp.SctpChannel javaChannel() {
        return (com.sun.nio.sctp.SctpChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        com.sun.nio.sctp.SctpChannel sctpChannel = this.javaChannel();
        return sctpChannel.isOpen() && this.association() != null;
    }

    @Override
    protected SocketAddress localAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.javaChannel().getAllLocalAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        try {
            Iterator<SocketAddress> iterator = this.javaChannel().getRemoteAddresses().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.javaChannel().bind(socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.javaChannel().bind(socketAddress2);
        }
        boolean bl2 = false;
        try {
            boolean bl3 = this.javaChannel().connect(socketAddress);
            if (!bl3) {
                this.selectionKey().interestOps(8);
            }
            bl2 = true;
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (!bl2) {
                this.doClose();
            }
        }
    }

    @Override
    protected void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        this.javaChannel().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doReadMessages(List<Object> list) {
        int n2;
        com.sun.nio.sctp.SctpChannel sctpChannel = this.javaChannel();
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        ByteBuf byteBuf = recvByteBufAllocator$Handle.allocate(this.config().getAllocator());
        boolean bl2 = true;
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
            n2 = byteBuffer.position();
            MessageInfo messageInfo = sctpChannel.receive(byteBuffer, null, this.notificationHandler);
            if (messageInfo == null) {
                int n3 = 0;
                return n3;
            }
            recvByteBufAllocator$Handle.lastBytesRead(byteBuffer.position() - n2);
            list.add(new SctpMessage(messageInfo, byteBuf.writerIndex(byteBuf.writerIndex() + recvByteBufAllocator$Handle.lastBytesRead())));
            bl2 = false;
            int n4 = 1;
            return n4;
        }
        catch (Throwable throwable) {
            PlatformDependent.throwException(throwable);
            n2 = -1;
            return n2;
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    @Override
    protected boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        boolean bl2;
        SctpMessage sctpMessage = (SctpMessage)object;
        ByteBuf byteBuf = sctpMessage.content();
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return true;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        boolean bl3 = bl2 = byteBuf.nioBufferCount() != 1;
        if (!bl2 && !byteBuf.isDirect() && byteBufAllocator.isDirectBufferPooled()) {
            bl2 = true;
        }
        if (bl2) {
            byteBuf = byteBufAllocator.directBuffer(n2).writeBytes(byteBuf);
        }
        ByteBuffer byteBuffer = byteBuf.nioBuffer();
        MessageInfo messageInfo = MessageInfo.createOutgoing(this.association(), null, sctpMessage.streamIdentifier());
        messageInfo.payloadProtocolID(sctpMessage.protocolIdentifier());
        messageInfo.streamNumber(sctpMessage.streamIdentifier());
        messageInfo.unordered(sctpMessage.isUnordered());
        int n3 = this.javaChannel().send(byteBuffer, messageInfo);
        return n3 > 0;
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof SctpMessage) {
            SctpMessage sctpMessage = (SctpMessage)object;
            ByteBuf byteBuf = sctpMessage.content();
            if (byteBuf.isDirect() && byteBuf.nioBufferCount() == 1) {
                return sctpMessage;
            }
            return new SctpMessage(sctpMessage.protocolIdentifier(), sctpMessage.streamIdentifier(), sctpMessage.isUnordered(), this.newDirectBuffer(sctpMessage, byteBuf));
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + " (expected: " + StringUtil.simpleClassName(SctpMessage.class));
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress) {
        return this.bindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture bindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.javaChannel().bindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new NioSctpChannel$1(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress) {
        return this.unbindAddress(inetAddress, this.newPromise());
    }

    @Override
    public ChannelFuture unbindAddress(InetAddress inetAddress, ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            try {
                this.javaChannel().unbindAddress(inetAddress);
                channelPromise.setSuccess();
            }
            catch (Throwable throwable) {
                channelPromise.setFailure(throwable);
            }
        } else {
            this.eventLoop().execute(new NioSctpChannel$2(this, inetAddress, channelPromise));
        }
        return channelPromise;
    }

    static /* synthetic */ void access$100(NioSctpChannel nioSctpChannel) {
        nioSctpChannel.clearReadPending();
    }
}

