/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.MessageInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;

public final class SctpMessage
extends DefaultByteBufHolder {
    private final int streamIdentifier;
    private final int protocolIdentifier;
    private final boolean unordered;
    private final MessageInfo msgInfo;

    public SctpMessage(int n2, int n3, ByteBuf byteBuf) {
        this(n2, n3, false, byteBuf);
    }

    public SctpMessage(int n2, int n3, boolean bl2, ByteBuf byteBuf) {
        super(byteBuf);
        this.protocolIdentifier = n2;
        this.streamIdentifier = n3;
        this.unordered = bl2;
        this.msgInfo = null;
    }

    public SctpMessage(MessageInfo messageInfo, ByteBuf byteBuf) {
        super(byteBuf);
        if (messageInfo == null) {
            throw new NullPointerException("msgInfo");
        }
        this.msgInfo = messageInfo;
        this.streamIdentifier = messageInfo.streamNumber();
        this.protocolIdentifier = messageInfo.payloadProtocolID();
        this.unordered = messageInfo.isUnordered();
    }

    public int streamIdentifier() {
        return this.streamIdentifier;
    }

    public int protocolIdentifier() {
        return this.protocolIdentifier;
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public MessageInfo messageInfo() {
        return this.msgInfo;
    }

    public boolean isComplete() {
        if (this.msgInfo != null) {
            return this.msgInfo.isComplete();
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SctpMessage sctpMessage = (SctpMessage)object;
        if (this.protocolIdentifier != sctpMessage.protocolIdentifier) {
            return false;
        }
        if (this.streamIdentifier != sctpMessage.streamIdentifier) {
            return false;
        }
        if (this.unordered != sctpMessage.unordered) {
            return false;
        }
        return this.content().equals(sctpMessage.content());
    }

    @Override
    public int hashCode() {
        int n2 = this.streamIdentifier;
        n2 = 31 * n2 + this.protocolIdentifier;
        n2 = 31 * n2 + (this.unordered ? 1231 : 1237);
        n2 = 31 * n2 + this.content().hashCode();
        return n2;
    }

    @Override
    public SctpMessage copy() {
        return (SctpMessage)super.copy();
    }

    @Override
    public SctpMessage duplicate() {
        return (SctpMessage)super.duplicate();
    }

    @Override
    public SctpMessage retainedDuplicate() {
        return (SctpMessage)super.retainedDuplicate();
    }

    @Override
    public SctpMessage replace(ByteBuf byteBuf) {
        if (this.msgInfo == null) {
            return new SctpMessage(this.protocolIdentifier, this.streamIdentifier, this.unordered, byteBuf);
        }
        return new SctpMessage(this.msgInfo, byteBuf);
    }

    @Override
    public SctpMessage retain() {
        super.retain();
        return this;
    }

    @Override
    public SctpMessage retain(int n2) {
        super.retain(n2);
        return this;
    }

    @Override
    public SctpMessage touch() {
        super.touch();
        return this;
    }

    @Override
    public SctpMessage touch(Object object) {
        super.touch(object);
        return this;
    }

    @Override
    public String toString() {
        return "SctpFrame{streamIdentifier=" + this.streamIdentifier + ", protocolIdentifier=" + this.protocolIdentifier + ", unordered=" + this.unordered + ", data=" + this.contentToString() + '}';
    }
}

