/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.SctpStandardSocketOptions;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.sctp.SctpChannelOption;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.SctpServerChannelConfig;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.util.Map;

public class DefaultSctpServerChannelConfig
extends DefaultChannelConfig
implements SctpServerChannelConfig {
    private final com.sun.nio.sctp.SctpServerChannel javaChannel;
    private volatile int backlog = NetUtil.SOMAXCONN;

    public DefaultSctpServerChannelConfig(SctpServerChannel sctpServerChannel, com.sun.nio.sctp.SctpServerChannel sctpServerChannel2) {
        super(sctpServerChannel);
        if (sctpServerChannel2 == null) {
            throw new NullPointerException("javaChannel");
        }
        this.javaChannel = sctpServerChannel2;
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, SctpChannelOption.SCTP_INIT_MAXSTREAMS);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == SctpChannelOption.SCTP_INIT_MAXSTREAMS) {
            return (T)this.getInitMaxStreams();
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t2);
        } else if (channelOption == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t2);
        } else if (channelOption == SctpChannelOption.SCTP_INIT_MAXSTREAMS) {
            this.setInitMaxStreams((SctpStandardSocketOptions.InitMaxStreams)t2);
        } else {
            return super.setOption(channelOption, t2);
        }
        return true;
    }

    @Override
    public int getSendBufferSize() {
        try {
            return this.javaChannel.getOption(SctpStandardSocketOptions.SO_SNDBUF);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public SctpServerChannelConfig setSendBufferSize(int n2) {
        try {
            this.javaChannel.setOption(SctpStandardSocketOptions.SO_SNDBUF, n2);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    @Override
    public int getReceiveBufferSize() {
        try {
            return this.javaChannel.getOption(SctpStandardSocketOptions.SO_RCVBUF);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public SctpServerChannelConfig setReceiveBufferSize(int n2) {
        try {
            this.javaChannel.setOption(SctpStandardSocketOptions.SO_RCVBUF, n2);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    @Override
    public SctpStandardSocketOptions.InitMaxStreams getInitMaxStreams() {
        try {
            return this.javaChannel.getOption(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public SctpServerChannelConfig setInitMaxStreams(SctpStandardSocketOptions.InitMaxStreams initMaxStreams) {
        try {
            this.javaChannel.setOption(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS, initMaxStreams);
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
        return this;
    }

    @Override
    public int getBacklog() {
        return this.backlog;
    }

    @Override
    public SctpServerChannelConfig setBacklog(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("backlog: " + n2);
        }
        this.backlog = n2;
        return this;
    }

    @Override
    @Deprecated
    public SctpServerChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public SctpServerChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public SctpServerChannelConfig setAutoRead(boolean bl2) {
        super.setAutoRead(bl2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setAutoClose(boolean bl2) {
        super.setAutoClose(bl2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public SctpServerChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public SctpServerChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }
}

