/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ReadOnlyIterator;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannelPoolMap<K, P extends ChannelPool>
implements ChannelPoolMap<K, P>,
Closeable,
Iterable<Map.Entry<K, P>> {
    private final ConcurrentMap<K, P> map = PlatformDependent.newConcurrentHashMap();

    @Override
    public final P get(K k2) {
        ChannelPool channelPool;
        ChannelPool channelPool2 = (ChannelPool)this.map.get(ObjectUtil.checkNotNull(k2, "key"));
        if (channelPool2 == null && (channelPool = this.map.putIfAbsent(k2, channelPool2 = this.newPool(k2))) != null) {
            channelPool2.close();
            channelPool2 = channelPool;
        }
        return (P)channelPool2;
    }

    public final boolean remove(K k2) {
        ChannelPool channelPool = (ChannelPool)this.map.remove(ObjectUtil.checkNotNull(k2, "key"));
        if (channelPool != null) {
            channelPool.close();
            return true;
        }
        return false;
    }

    @Override
    public final Iterator<Map.Entry<K, P>> iterator() {
        return new ReadOnlyIterator<Map.Entry<K, P>>(this.map.entrySet().iterator());
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final boolean contains(K k2) {
        return this.map.containsKey(ObjectUtil.checkNotNull(k2, "key"));
    }

    protected abstract P newPool(K var1);

    @Override
    public final void close() {
        for (Object k2 : this.map.keySet()) {
            this.remove(k2);
        }
    }
}

