/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator$Handle;
import io.netty.channel.oio.AbstractOioByteChannel;
import io.netty.channel.oio.OioByteStreamChannel$1;
import io.netty.channel.oio.OioByteStreamChannel$2;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.WritableByteChannel;

public abstract class OioByteStreamChannel
extends AbstractOioByteChannel {
    private static final InputStream CLOSED_IN = new OioByteStreamChannel$1();
    private static final OutputStream CLOSED_OUT = new OioByteStreamChannel$2();
    private InputStream is;
    private OutputStream os;
    private WritableByteChannel outChannel;

    protected OioByteStreamChannel(Channel channel) {
        super(channel);
    }

    protected final void activate(InputStream inputStream, OutputStream outputStream) {
        if (this.is != null) {
            throw new IllegalStateException("input was set already");
        }
        if (this.os != null) {
            throw new IllegalStateException("output was set already");
        }
        if (inputStream == null) {
            throw new NullPointerException("is");
        }
        if (outputStream == null) {
            throw new NullPointerException("os");
        }
        this.is = inputStream;
        this.os = outputStream;
    }

    @Override
    public boolean isActive() {
        InputStream inputStream = this.is;
        if (inputStream == null || inputStream == CLOSED_IN) {
            return false;
        }
        OutputStream outputStream = this.os;
        return outputStream != null && outputStream != CLOSED_OUT;
    }

    @Override
    protected int available() {
        try {
            return this.is.available();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) {
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.attemptedBytesRead(Math.max(1, Math.min(this.available(), byteBuf.maxWritableBytes())));
        return byteBuf.writeBytes(this.is, recvByteBufAllocator$Handle.attemptedBytesRead());
    }

    @Override
    protected void doWriteBytes(ByteBuf byteBuf) {
        OutputStream outputStream = this.os;
        if (outputStream == null) {
            throw new NotYetConnectedException();
        }
        byteBuf.readBytes(outputStream, byteBuf.readableBytes());
    }

    @Override
    protected void doWriteFileRegion(FileRegion fileRegion) {
        long l2;
        OutputStream outputStream = this.os;
        if (outputStream == null) {
            throw new NotYetConnectedException();
        }
        if (this.outChannel == null) {
            this.outChannel = Channels.newChannel(outputStream);
        }
        long l3 = 0L;
        do {
            if ((l2 = fileRegion.transferTo(this.outChannel, l3)) != -1L) continue;
            OioByteStreamChannel.checkEOF(fileRegion);
            return;
        } while ((l3 += l2) < fileRegion.count());
    }

    private static void checkEOF(FileRegion fileRegion) {
        if (fileRegion.transferred() < fileRegion.count()) {
            throw new EOFException("Expected to be able to write " + fileRegion.count() + " bytes, but only wrote " + fileRegion.transferred());
        }
    }

    @Override
    protected void doClose() {
        InputStream inputStream = this.is;
        OutputStream outputStream = this.os;
        this.is = CLOSED_IN;
        this.os = CLOSED_OUT;
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

