/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator$Handle;
import io.netty.channel.oio.AbstractOioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.StringUtil;
import java.io.IOException;

public abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(FileRegion.class) + ')';

    protected AbstractOioByteChannel(Channel channel) {
        super(channel);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected abstract boolean isInputShutdown();

    protected abstract ChannelFuture shutdownInput();

    private void closeOnRead(ChannelPipeline channelPipeline) {
        if (this.isOpen()) {
            if (Boolean.TRUE.equals(this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                this.shutdownInput();
                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.unsafe().close(this.unsafe().voidPromise());
            }
            channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl2, RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        recvByteBufAllocator$Handle.readComplete();
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl2 || throwable instanceof IOException) {
            this.closeOnRead(channelPipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRead() {
        ChannelConfig channelConfig = this.config();
        if (this.isInputShutdown() || !this.readPending) {
            return;
        }
        this.readPending = false;
        ChannelPipeline channelPipeline = this.pipeline();
        ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.reset(channelConfig);
        ByteBuf byteBuf = null;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
            do {
                int n2;
                recvByteBufAllocator$Handle.lastBytesRead(this.doReadBytes(byteBuf));
                if (recvByteBufAllocator$Handle.lastBytesRead() <= 0) {
                    if (byteBuf.isReadable()) break;
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl4 = bl2 = recvByteBufAllocator$Handle.lastBytesRead() < 0;
                    if (!bl2) break;
                    this.readPending = false;
                    break;
                }
                bl3 = true;
                int n3 = this.available();
                if (n3 <= 0) break;
                if (byteBuf.isWritable()) continue;
                int n4 = byteBuf.capacity();
                if (n4 == (n2 = byteBuf.maxCapacity())) {
                    recvByteBufAllocator$Handle.incMessagesRead(1);
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                    byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
                    continue;
                }
                int n5 = byteBuf.writerIndex();
                if (n5 + n3 > n2) {
                    byteBuf.capacity(n2);
                    continue;
                }
                byteBuf.ensureWritable(n3);
            } while (recvByteBufAllocator$Handle.continueReading());
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    this.readPending = false;
                    channelPipeline.fireChannelRead(byteBuf);
                } else {
                    byteBuf.release();
                }
                byteBuf = null;
            }
            if (bl3) {
                recvByteBufAllocator$Handle.readComplete();
                channelPipeline.fireChannelReadComplete();
            }
            if (bl2) {
                this.closeOnRead(channelPipeline);
            }
        }
        catch (Throwable throwable) {
            this.handleReadException(channelPipeline, byteBuf, throwable, bl2, recvByteBufAllocator$Handle);
        }
        finally {
            if (this.readPending || channelConfig.isAutoRead() || !bl3 && this.isActive()) {
                this.read();
            }
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCounted referenceCounted;
            if (object instanceof ByteBuf) {
                referenceCounted = (ByteBuf)object;
                int n2 = ((ByteBuf)referenceCounted).readableBytes();
                while (n2 > 0) {
                    this.doWriteBytes((ByteBuf)referenceCounted);
                    int n3 = ((ByteBuf)referenceCounted).readableBytes();
                    channelOutboundBuffer.progress(n2 - n3);
                    n2 = n3;
                }
                channelOutboundBuffer.remove();
                continue;
            }
            if (object instanceof FileRegion) {
                referenceCounted = (FileRegion)object;
                long l2 = referenceCounted.transferred();
                this.doWriteFileRegion((FileRegion)referenceCounted);
                channelOutboundBuffer.progress(referenceCounted.transferred() - l2);
                channelOutboundBuffer.remove();
                continue;
            }
            channelOutboundBuffer.remove(new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object)));
        }
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf || object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1);

    protected abstract void doWriteBytes(ByteBuf var1);

    protected abstract void doWriteFileRegion(FileRegion var1);
}

