/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.EventLoopException;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import io.netty.channel.nio.NioEventLoop$1;
import io.netty.channel.nio.NioEventLoop$2;
import io.netty.channel.nio.NioEventLoop$3;
import io.netty.channel.nio.NioEventLoop$4;
import io.netty.channel.nio.NioEventLoop$5;
import io.netty.channel.nio.NioEventLoop$6;
import io.netty.channel.nio.NioEventLoop$SelectorTuple;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.nio.NioTask;
import io.netty.channel.nio.SelectedSelectionKeySet;
import io.netty.channel.nio.SelectedSelectionKeySetSelector;
import io.netty.util.IntSupplier;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger;
    private static final int CLEANUP_INTERVAL = 256;
    private static final boolean DISABLE_KEYSET_OPTIMIZATION;
    private static final int MIN_PREMATURE_SELECTOR_RETURNS = 3;
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new NioEventLoop$1(this);
    private final Callable<Integer> pendingTasksCallable = new NioEventLoop$2(this);
    static final long MAX_SCHEDULED_DAYS = 1095L;
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final SelectStrategy selectStrategy;
    private volatile int ioRatio = 50;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    NioEventLoop(NioEventLoopGroup nioEventLoopGroup, Executor executor, SelectorProvider selectorProvider, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler) {
        super((EventLoopGroup)nioEventLoopGroup, executor, false, DEFAULT_MAX_PENDING_TASKS, rejectedExecutionHandler);
        if (selectorProvider == null) {
            throw new NullPointerException("selectorProvider");
        }
        if (selectStrategy == null) {
            throw new NullPointerException("selectStrategy");
        }
        this.provider = selectorProvider;
        NioEventLoop$SelectorTuple nioEventLoop$SelectorTuple = this.openSelector();
        this.selector = nioEventLoop$SelectorTuple.selector;
        this.unwrappedSelector = nioEventLoop$SelectorTuple.unwrappedSelector;
        this.selectStrategy = selectStrategy;
    }

    private NioEventLoop$SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEYSET_OPTIMIZATION) {
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        SelectedSelectionKeySet selectedSelectionKeySet = new SelectedSelectionKeySet();
        Object object = AccessController.doPrivileged(new NioEventLoop$4(this));
        if (!(object instanceof Class) || !((Class)object).isAssignableFrom(abstractSelector.getClass())) {
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, (Object)throwable);
            }
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        Class clazz = (Class)object;
        Object object2 = AccessController.doPrivileged(new NioEventLoop$5(this, clazz, abstractSelector, selectedSelectionKeySet));
        if (object2 instanceof Exception) {
            this.selectedKeys = null;
            Exception exception = (Exception)object2;
            logger.trace("failed to instrument a special java.util.Set into: {}", (Object)abstractSelector, (Object)exception);
            return new NioEventLoop$SelectorTuple(abstractSelector);
        }
        this.selectedKeys = selectedSelectionKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", (Object)abstractSelector);
        return new NioEventLoop$SelectorTuple(abstractSelector, new SelectedSelectionKeySetSelector(abstractSelector, selectedSelectionKeySet));
    }

    public SelectorProvider selectorProvider() {
        return this.provider;
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int n2) {
        return n2 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n2);
    }

    @Override
    public int pendingTasks() {
        if (this.inEventLoop()) {
            return super.pendingTasks();
        }
        return (Integer)this.submit(this.pendingTasksCallable).syncUninterruptibly().getNow();
    }

    public void register(SelectableChannel selectableChannel, int n2, NioTask<?> nioTask) {
        if (selectableChannel == null) {
            throw new NullPointerException("ch");
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("interestOps must be non-zero.");
        }
        if ((n2 & ~selectableChannel.validOps()) != 0) {
            throw new IllegalArgumentException("invalid interestOps: " + n2 + "(validOps: " + selectableChannel.validOps() + ')');
        }
        if (nioTask == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            throw new IllegalStateException("event loop shut down");
        }
        try {
            selectableChannel.register(this.selector, n2, nioTask);
        }
        catch (Exception exception) {
            throw new EventLoopException("failed to register a channel", exception);
        }
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n2) {
        if (n2 <= 0 || n2 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n2 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n2;
    }

    public void rebuildSelector() {
        if (!this.inEventLoop()) {
            this.execute(new NioEventLoop$6(this));
            return;
        }
        this.rebuildSelector0();
    }

    private void rebuildSelector0() {
        int n2;
        block10: {
            NioEventLoop$SelectorTuple nioEventLoop$SelectorTuple;
            Selector selector = this.selector;
            if (selector == null) {
                return;
            }
            try {
                nioEventLoop$SelectorTuple = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n2 = 0;
            for (SelectionKey selectionKey : selector.keys()) {
                Object object;
                Object object2 = selectionKey.attachment();
                try {
                    if (!selectionKey.isValid() || selectionKey.channel().keyFor(nioEventLoop$SelectorTuple.unwrappedSelector) != null) continue;
                    int n3 = selectionKey.interestOps();
                    selectionKey.cancel();
                    object = selectionKey.channel().register(nioEventLoop$SelectorTuple.unwrappedSelector, n3, object2);
                    if (object2 instanceof AbstractNioChannel) {
                        ((AbstractNioChannel)object2).selectionKey = object;
                    }
                    ++n2;
                }
                catch (Exception exception) {
                    logger.warn("Failed to re-register a Channel to the new Selector.", exception);
                    if (object2 instanceof AbstractNioChannel) {
                        object = (AbstractNioChannel)object2;
                        ((AbstractNioChannel)object).unsafe().close(((AbstractNioChannel)object).unsafe().voidPromise());
                        continue;
                    }
                    object = (NioTask)object2;
                    NioEventLoop.invokeChannelUnregistered((NioTask<SelectableChannel>)object, selectionKey, exception);
                }
            }
            this.selector = nioEventLoop$SelectorTuple.selector;
            this.unwrappedSelector = nioEventLoop$SelectorTuple.unwrappedSelector;
            try {
                selector.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block10;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        logger.info("Migrated " + n2 + " channel(s) to the new Selector.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        while (true) {
            block17: {
                try {
                    block15: while (true) {
                        switch (this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks())) {
                            case -2: {
                                continue block15;
                            }
                            case -1: {
                                this.select(this.wakenUp.getAndSet(false));
                                if (!this.wakenUp.get()) break block15;
                                this.selector.wakeup();
                            }
                        }
                        break;
                    }
                    this.cancelledKeys = 0;
                    this.needsToSelectAgain = false;
                    int n2 = this.ioRatio;
                    if (n2 == 100) {
                        try {
                            this.processSelectedKeys();
                            break block17;
                        }
                        finally {
                            this.runAllTasks();
                        }
                    }
                    long l2 = System.nanoTime();
                    try {
                        this.processSelectedKeys();
                    }
                    finally {
                        long l3 = System.nanoTime() - l2;
                        this.runAllTasks(l3 * (long)(100 - n2) / (long)n2);
                    }
                }
                catch (Throwable throwable) {
                    NioEventLoop.handleLoopException(throwable);
                }
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
                return;
            }
            catch (Throwable throwable) {
                NioEventLoop.handleLoopException(throwable);
                continue;
            }
            break;
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processSelectedKeys() {
        if (this.selectedKeys != null) {
            this.processSelectedKeysOptimized();
        } else {
            this.processSelectedKeysPlain(this.selector.selectedKeys());
        }
    }

    @Override
    protected void cleanup() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
    }

    void cancel(SelectionKey selectionKey) {
        selectionKey.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
        }
    }

    @Override
    protected Runnable pollTask() {
        Runnable runnable = super.pollTask();
        if (this.needsToSelectAgain) {
            this.selectAgain();
        }
        return runnable;
    }

    private void processSelectedKeysPlain(Set<SelectionKey> set) {
        if (set.isEmpty()) {
            return;
        }
        Iterator<SelectionKey> iterator = set.iterator();
        while (true) {
            SelectionKey selectionKey = iterator.next();
            Object object = selectionKey.attachment();
            iterator.remove();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!iterator.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            set = this.selector.selectedKeys();
            if (set.isEmpty()) break;
            iterator = set.iterator();
        }
    }

    private void processSelectedKeysOptimized() {
        for (int i2 = 0; i2 < this.selectedKeys.size; ++i2) {
            SelectionKey selectionKey = this.selectedKeys.keys[i2];
            this.selectedKeys.keys[i2] = null;
            Object object = selectionKey.attachment();
            if (object instanceof AbstractNioChannel) {
                this.processSelectedKey(selectionKey, (AbstractNioChannel)object);
            } else {
                NioTask nioTask = (NioTask)object;
                NioEventLoop.processSelectedKey(selectionKey, nioTask);
            }
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i2 + 1);
            this.selectAgain();
            i2 = -1;
        }
    }

    private void processSelectedKey(SelectionKey selectionKey, AbstractNioChannel abstractNioChannel) {
        AbstractNioChannel$NioUnsafe abstractNioChannel$NioUnsafe = abstractNioChannel.unsafe();
        if (!selectionKey.isValid()) {
            NioEventLoop nioEventLoop;
            try {
                nioEventLoop = abstractNioChannel.eventLoop();
            }
            catch (Throwable throwable) {
                return;
            }
            if (nioEventLoop != this || nioEventLoop == null) {
                return;
            }
            abstractNioChannel$NioUnsafe.close(abstractNioChannel$NioUnsafe.voidPromise());
            return;
        }
        try {
            int n2 = selectionKey.readyOps();
            if ((n2 & 8) != 0) {
                int n3 = selectionKey.interestOps();
                selectionKey.interestOps(n3 &= 0xFFFFFFF7);
                abstractNioChannel$NioUnsafe.finishConnect();
            }
            if ((n2 & 4) != 0) {
                abstractNioChannel.unsafe().forceFlush();
            }
            if ((n2 & 0x11) != 0 || n2 == 0) {
                abstractNioChannel$NioUnsafe.read();
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            abstractNioChannel$NioUnsafe.close(abstractNioChannel$NioUnsafe.voidPromise());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processSelectedKey(SelectionKey selectionKey, NioTask<SelectableChannel> nioTask) {
        int n2 = 0;
        try {
            nioTask.channelReady(selectionKey.channel(), selectionKey);
            n2 = 1;
        }
        catch (Exception exception) {
            selectionKey.cancel();
            NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, exception);
            n2 = 2;
        }
        finally {
            switch (n2) {
                case 0: {
                    selectionKey.cancel();
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                    break;
                }
                case 1: {
                    if (selectionKey.isValid()) break;
                    NioEventLoop.invokeChannelUnregistered(nioTask, selectionKey, null);
                }
            }
        }
    }

    private void closeAll() {
        this.selectAgain();
        Set<SelectionKey> set = this.selector.keys();
        ArrayList<AbstractNioChannel> arrayList = new ArrayList<AbstractNioChannel>(set.size());
        for (SelectionKey object : set) {
            Object object2 = object.attachment();
            if (object2 instanceof AbstractNioChannel) {
                arrayList.add((AbstractNioChannel)object2);
                continue;
            }
            object.cancel();
            NioTask nioTask = (NioTask)object2;
            NioEventLoop.invokeChannelUnregistered(nioTask, object, null);
        }
        for (AbstractNioChannel abstractNioChannel : arrayList) {
            abstractNioChannel.unsafe().close(abstractNioChannel.unsafe().voidPromise());
        }
    }

    private static void invokeChannelUnregistered(NioTask<SelectableChannel> nioTask, SelectionKey selectionKey, Throwable throwable) {
        try {
            nioTask.channelUnregistered(selectionKey.channel(), throwable);
        }
        catch (Exception exception) {
            logger.warn("Unexpected exception while running NioTask.channelUnregistered()", exception);
        }
    }

    @Override
    protected void wakeup(boolean bl2) {
        if (!bl2 && this.wakenUp.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    int selectNow() {
        try {
            int n2 = this.selector.selectNow();
            return n2;
        }
        finally {
            if (this.wakenUp.get()) {
                this.selector.wakeup();
            }
        }
    }

    private void select(boolean bl2) {
        block11: {
            Selector selector = this.selector;
            try {
                int n2 = 0;
                long l2 = System.nanoTime();
                long l3 = l2 + this.delayNanos(l2);
                while (true) {
                    long l4;
                    if ((l4 = (l3 - l2 + 500000L) / 1000000L) <= 0L) {
                        if (n2 != 0) break;
                        selector.selectNow();
                        n2 = 1;
                        break;
                    }
                    if (this.hasTasks() && this.wakenUp.compareAndSet(false, true)) {
                        selector.selectNow();
                        n2 = 1;
                        break;
                    }
                    int n3 = selector.select(l4);
                    ++n2;
                    if (n3 != 0 || bl2 || this.wakenUp.get() || this.hasTasks() || this.hasScheduledTasks()) break;
                    if (Thread.interrupted()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioEventLoop.shutdownGracefully() to shutdown the NioEventLoop.");
                        }
                        n2 = 1;
                        break;
                    }
                    long l5 = System.nanoTime();
                    if (l5 - TimeUnit.MILLISECONDS.toNanos(l4) >= l2) {
                        n2 = 1;
                    } else if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n2 >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
                        logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n2, (Object)selector);
                        this.rebuildSelector();
                        selector = this.selector;
                        selector.selectNow();
                        n2 = 1;
                        break;
                    }
                    l2 = l5;
                }
                if (n2 > 3 && logger.isDebugEnabled()) {
                    logger.debug("Selector.select() returned prematurely {} times in a row for Selector {}.", (Object)(n2 - 1), (Object)selector);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!logger.isDebugEnabled()) break block11;
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector {} - JDK bug?", (Object)selector, (Object)cancelledKeyException);
            }
        }
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
        }
    }

    @Override
    protected void validateScheduled(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toDays(l2);
        if (l3 > 1095L) {
            throw new IllegalArgumentException("days: " + l3 + " (expected: < " + 1095L + ')');
        }
    }

    static /* synthetic */ int access$001(NioEventLoop nioEventLoop) {
        return super.pendingTasks();
    }

    static /* synthetic */ void access$100(NioEventLoop nioEventLoop) {
        nioEventLoop.rebuildSelector0();
    }

    static {
        int n2;
        logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
        DISABLE_KEYSET_OPTIMIZATION = SystemPropertyUtil.getBoolean("io.netty.noKeySetOptimization", false);
        String string = "sun.nio.ch.bugLevel";
        String string2 = SystemPropertyUtil.get("sun.nio.ch.bugLevel");
        if (string2 == null) {
            try {
                AccessController.doPrivileged(new NioEventLoop$3());
            }
            catch (SecurityException securityException) {
                logger.debug("Unable to get/set System Property: sun.nio.ch.bugLevel", securityException);
            }
        }
        if ((n2 = SystemPropertyUtil.getInt("io.netty.selectorAutoRebuildThreshold", 512)) < 3) {
            n2 = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n2;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEYSET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }
}

