/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import io.netty.channel.nio.AbstractNioMessageChannel$NioMessageUnsafe;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.List;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    boolean inputShutdown;

    protected AbstractNioMessageChannel(Channel channel, SelectableChannel selectableChannel, int n2) {
        super(channel, selectableChannel, n2);
    }

    @Override
    protected AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new AbstractNioMessageChannel$NioMessageUnsafe(this, null);
    }

    @Override
    protected void doBeginRead() {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        SelectionKey selectionKey = this.selectionKey();
        int n2 = selectionKey.interestOps();
        while (true) {
            Object object;
            if ((object = channelOutboundBuffer.current()) == null) {
                if ((n2 & 4) == 0) break;
                selectionKey.interestOps(n2 & 0xFFFFFFFB);
                break;
            }
            try {
                boolean bl2 = false;
                for (int i2 = this.config().getWriteSpinCount() - 1; i2 >= 0; --i2) {
                    if (!this.doWriteMessage(object, channelOutboundBuffer)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    channelOutboundBuffer.remove();
                    continue;
                }
                if ((n2 & 4) != 0) break;
                selectionKey.interestOps(n2 | 4);
            }
            catch (Exception exception) {
                if (this.continueOnWriteError()) {
                    channelOutboundBuffer.remove(exception);
                    continue;
                }
                throw exception;
            }
            break;
        }
    }

    protected boolean continueOnWriteError() {
        return false;
    }

    protected boolean closeOnReadError(Throwable throwable) {
        if (!this.isActive()) {
            return true;
        }
        if (throwable instanceof PortUnreachableException) {
            return false;
        }
        if (throwable instanceof IOException) {
            return !(this instanceof ServerChannel);
        }
        return true;
    }

    protected abstract int doReadMessages(List<Object> var1);

    protected abstract boolean doWriteMessage(Object var1, ChannelOutboundBuffer var2);
}

