/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.netty.channel.ChannelPromise;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe$1;
import io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe$2;
import io.netty.channel.nio.AbstractNioChannel$NioUnsafe;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.TimeUnit;

public abstract class AbstractNioChannel$AbstractNioUnsafe
extends AbstractChannel$AbstractUnsafe
implements AbstractNioChannel$NioUnsafe {
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ AbstractNioChannel this$0;

    protected AbstractNioChannel$AbstractNioUnsafe(AbstractNioChannel abstractNioChannel) {
        this.this$0 = abstractNioChannel;
        super(abstractNioChannel);
    }

    protected final void removeReadOp() {
        SelectionKey selectionKey = this.this$0.selectionKey();
        if (!selectionKey.isValid()) {
            return;
        }
        int n2 = selectionKey.interestOps();
        if ((n2 & this.this$0.readInterestOp) != 0) {
            selectionKey.interestOps(n2 & ~this.this$0.readInterestOp);
        }
    }

    @Override
    public final SelectableChannel ch() {
        return this.this$0.javaChannel();
    }

    @Override
    public final void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
            return;
        }
        try {
            if (AbstractNioChannel.access$200(this.this$0) != null) {
                throw new ConnectionPendingException();
            }
            boolean bl2 = this.this$0.isActive();
            if (this.this$0.doConnect(socketAddress, socketAddress2)) {
                this.fulfillConnectPromise(channelPromise, bl2);
            } else {
                AbstractNioChannel.access$202(this.this$0, channelPromise);
                AbstractNioChannel.access$302(this.this$0, socketAddress);
                int n2 = this.this$0.config().getConnectTimeoutMillis();
                if (n2 > 0) {
                    AbstractNioChannel.access$402(this.this$0, this.this$0.eventLoop().schedule(new AbstractNioChannel$AbstractNioUnsafe$1(this, socketAddress), (long)n2, TimeUnit.MILLISECONDS));
                }
                channelPromise.addListener(new AbstractNioChannel$AbstractNioUnsafe$2(this));
            }
        }
        catch (Throwable throwable) {
            channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
            this.closeIfClosed();
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl2) {
        if (channelPromise == null) {
            return;
        }
        boolean bl3 = this.this$0.isActive();
        boolean bl4 = channelPromise.trySuccess();
        if (!bl2 && bl3) {
            this.this$0.pipeline().fireChannelActive();
        }
        if (!bl4) {
            this.close(this.voidPromise());
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
        if (channelPromise == null) {
            return;
        }
        channelPromise.tryFailure(throwable);
        this.closeIfClosed();
    }

    @Override
    public final void finishConnect() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        try {
            boolean bl2 = this.this$0.isActive();
            this.this$0.doFinishConnect();
            this.fulfillConnectPromise(AbstractNioChannel.access$200(this.this$0), bl2);
        }
        catch (Throwable throwable) {
            this.fulfillConnectPromise(AbstractNioChannel.access$200(this.this$0), this.annotateConnectException(throwable, AbstractNioChannel.access$300(this.this$0)));
        }
        finally {
            if (AbstractNioChannel.access$400(this.this$0) != null) {
                AbstractNioChannel.access$400(this.this$0).cancel(false);
            }
            AbstractNioChannel.access$202(this.this$0, null);
        }
    }

    @Override
    protected final void flush0() {
        if (!this.isFlushPending()) {
            super.flush0();
        }
    }

    @Override
    public final void forceFlush() {
        super.flush0();
    }

    private boolean isFlushPending() {
        SelectionKey selectionKey = this.this$0.selectionKey();
        return selectionKey.isValid() && (selectionKey.interestOps() & 4) != 0;
    }

    static {
        $assertionsDisabled = !AbstractNioChannel.class.desiredAssertionStatus();
    }
}

