/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.RecvByteBufAllocator$Handle;
import io.netty.channel.nio.AbstractNioByteChannel;
import io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import java.io.IOException;

public class AbstractNioByteChannel$NioByteUnsafe
extends AbstractNioChannel$AbstractNioUnsafe {
    final /* synthetic */ AbstractNioByteChannel this$0;

    protected AbstractNioByteChannel$NioByteUnsafe(AbstractNioByteChannel abstractNioByteChannel) {
        this.this$0 = abstractNioByteChannel;
        super(abstractNioByteChannel);
    }

    private void closeOnRead(ChannelPipeline channelPipeline) {
        if (!this.this$0.isInputShutdown0()) {
            if (AbstractNioByteChannel.access$000(this.this$0.config())) {
                this.this$0.shutdownInput();
                channelPipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.close(this.voidPromise());
            }
        } else {
            AbstractNioByteChannel.access$102(this.this$0, true);
            channelPipeline.fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl2, RecvByteBufAllocator$Handle recvByteBufAllocator$Handle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.this$0.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        recvByteBufAllocator$Handle.readComplete();
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl2 || throwable instanceof IOException) {
            this.closeOnRead(channelPipeline);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void read() {
        ChannelConfig channelConfig = this.this$0.config();
        if (this.this$0.shouldBreakReadReady(channelConfig)) {
            this.this$0.clearReadPending();
            return;
        }
        ChannelPipeline channelPipeline = this.this$0.pipeline();
        ByteBufAllocator byteBufAllocator = channelConfig.getAllocator();
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.recvBufAllocHandle();
        recvByteBufAllocator$Handle.reset(channelConfig);
        ByteBuf byteBuf = null;
        boolean bl2 = false;
        try {
            do {
                byteBuf = recvByteBufAllocator$Handle.allocate(byteBufAllocator);
                recvByteBufAllocator$Handle.lastBytesRead(this.this$0.doReadBytes(byteBuf));
                if (recvByteBufAllocator$Handle.lastBytesRead() <= 0) {
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl3 = bl2 = recvByteBufAllocator$Handle.lastBytesRead() < 0;
                    if (!bl2) break;
                    this.this$0.readPending = false;
                    break;
                }
                recvByteBufAllocator$Handle.incMessagesRead(1);
                this.this$0.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
                byteBuf = null;
            } while (recvByteBufAllocator$Handle.continueReading());
            recvByteBufAllocator$Handle.readComplete();
            channelPipeline.fireChannelReadComplete();
            if (bl2) {
                this.closeOnRead(channelPipeline);
            }
        }
        catch (Throwable throwable) {
            this.handleReadException(channelPipeline, byteBuf, throwable, bl2, recvByteBufAllocator$Handle);
        }
        finally {
            if (!this.this$0.readPending && !channelConfig.isAutoRead()) {
                this.removeReadOp();
            }
        }
    }
}

