/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.unix.Limits;
import io.netty.util.internal.PlatformDependent;

final class NativeLongArray {
    private long memoryAddress;
    private int capacity;
    private int size;

    NativeLongArray(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("capacity must be >= 1 but was " + n2);
        }
        this.memoryAddress = PlatformDependent.allocateMemory(n2 * Limits.SIZEOF_JLONG);
        this.capacity = n2;
    }

    void add(long l2) {
        this.checkSize();
        PlatformDependent.putLong(this.memoryOffset(this.size++), l2);
    }

    void clear() {
        this.size = 0;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void free() {
        PlatformDependent.freeMemory(this.memoryAddress);
        this.memoryAddress = 0L;
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    long memoryAddressEnd() {
        return this.memoryOffset(this.size);
    }

    private long memoryOffset(int n2) {
        return this.memoryAddress + (long)(n2 * Limits.SIZEOF_JLONG);
    }

    private void checkSize() {
        if (this.size == this.capacity) {
            this.realloc();
        }
    }

    private void realloc() {
        int n2 = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
        long l2 = PlatformDependent.reallocateMemory(this.memoryAddress, n2 * Limits.SIZEOF_JLONG);
        if (l2 == 0L) {
            throw new OutOfMemoryError("unable to allocate " + n2 + " new bytes! Existing capacity is: " + this.capacity);
        }
        this.memoryAddress = l2;
        this.capacity = n2;
    }

    public String toString() {
        return "memoryAddress: " + this.memoryAddress + " capacity: " + this.capacity + " size: " + this.size;
    }
}

