/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventArray;
import io.netty.channel.kqueue.KQueueEventLoop$1;
import io.netty.channel.kqueue.KQueueEventLoop$2;
import io.netty.channel.kqueue.Native;
import io.netty.channel.kqueue.NativeLongArray;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class KQueueEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueEventLoop.class);
    private static final AtomicIntegerFieldUpdater<KQueueEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueEventLoop.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private final NativeLongArray jniChannelPointers;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = new KQueueEventLoop$1(this);
    private final Callable<Integer> pendingTasksCallable = new KQueueEventLoop$2(this);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;
    static final long MAX_SCHEDULED_DAYS = 1095L;

    KQueueEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n2, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventLoopGroup, executor, false, DEFAULT_MAX_PENDING_TASKS, rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "strategy");
        this.kqueueFd = Native.newKQueue();
        if (n2 == 0) {
            this.allowGrowing = true;
            n2 = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(n2);
        this.eventList = new KQueueEventArray(n2);
        this.jniChannelPointers = new NativeLongArray(4096);
        int n3 = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (n3 < 0) {
            this.cleanup();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -n3);
        }
    }

    void evSet(AbstractKQueueChannel abstractKQueueChannel, short s2, short s3, int n2) {
        this.changeList.evSet(abstractKQueueChannel, s2, s3, n2);
    }

    void remove(AbstractKQueueChannel abstractKQueueChannel) {
        assert (this.inEventLoop());
        if (abstractKQueueChannel.jniSelfPtr == 0L) {
            return;
        }
        this.jniChannelPointers.add(abstractKQueueChannel.jniSelfPtr);
        abstractKQueueChannel.jniSelfPtr = 0L;
    }

    IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    @Override
    protected void wakeup(boolean bl2) {
        if (!bl2 && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(boolean bl2) {
        if (bl2 && this.hasTasks()) {
            return this.kqueueWaitNow();
        }
        long l2 = this.delayNanos(System.nanoTime());
        int n2 = (int)Math.min(l2 / 1000000000L, Integer.MAX_VALUE);
        return this.kqueueWait(n2, (int)Math.min(l2 - (long)n2 * 1000000000L, Integer.MAX_VALUE));
    }

    private int kqueueWaitNow() {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int n2, int n3) {
        this.deleteJniChannelPointers();
        int n4 = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, n2, n3);
        this.changeList.clear();
        return n4;
    }

    private void deleteJniChannelPointers() {
        if (!this.jniChannelPointers.isEmpty()) {
            KQueueEventArray.deleteGlobalRefs(this.jniChannelPointers.memoryAddress(), this.jniChannelPointers.memoryAddressEnd());
            this.jniChannelPointers.clear();
        }
    }

    private void processReady(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            short s2 = this.eventList.filter(i2);
            short s3 = this.eventList.flags(i2);
            if (s2 == Native.EVFILT_USER || (s3 & Native.EV_ERROR) != 0) {
                assert (s2 != Native.EVFILT_USER || s2 == Native.EVFILT_USER && this.eventList.fd(i2) == 0);
                continue;
            }
            AbstractKQueueChannel abstractKQueueChannel = this.eventList.channel(i2);
            if (abstractKQueueChannel == null) {
                logger.warn("events[{}]=[{}, {}] had no channel!", i2, this.eventList.fd(i2), s2);
                continue;
            }
            AbstractKQueueChannel$AbstractKQueueUnsafe abstractKQueueChannel$AbstractKQueueUnsafe = (AbstractKQueueChannel$AbstractKQueueUnsafe)abstractKQueueChannel.unsafe();
            if (s2 == Native.EVFILT_WRITE) {
                abstractKQueueChannel$AbstractKQueueUnsafe.writeReady();
            } else if (s2 == Native.EVFILT_READ) {
                abstractKQueueChannel$AbstractKQueueUnsafe.readReady(this.eventList.data(i2));
            } else if (s2 == Native.EVFILT_SOCK && (this.eventList.fflags(i2) & Native.NOTE_RDHUP) != 0) {
                abstractKQueueChannel$AbstractKQueueUnsafe.readEOF();
            }
            if ((s3 & Native.EV_EOF) == 0) continue;
            abstractKQueueChannel$AbstractKQueueUnsafe.readEOF();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void run() {
        while (true) {
            try {
                block15: while (true) {
                    var1_1 = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (var1_1) {
                        case -2: {
                            continue block15;
                        }
                        case -1: {
                            var1_1 = this.kqueueWait(KQueueEventLoop.WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                            if (this.wakenUp != 1) break block15;
                            this.wakeup();
                        }
                    }
                    break;
                }
                var2_4 = this.ioRatio;
                if (var2_4 == 100) {
                    try {
                        if (var1_1 <= 0) ** GOTO lbl32
                        this.processReady(var1_1);
                    }
                    finally {
                        this.runAllTasks();
                    }
                } else {
                    var3_5 = System.nanoTime();
                    try {
                        if (var1_1 > 0) {
                            this.processReady(var1_1);
                        }
                    }
                    finally {
                        var5_7 = System.nanoTime() - var3_5;
                        this.runAllTasks(var5_7 * (long)(100 - var2_4) / (long)var2_4);
                    }
                }
                if (this.allowGrowing && var1_1 == this.eventList.capacity()) {
                    this.eventList.realloc(false);
                }
            }
            catch (Throwable var1_2) {
                KQueueEventLoop.handleLoopException(var1_2);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
            }
            catch (Throwable var1_3) {
                KQueueEventLoop.handleLoopException(var1_3);
                continue;
            }
            break;
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int n2) {
        return n2 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n2);
    }

    @Override
    public int pendingTasks() {
        return this.inEventLoop() ? super.pendingTasks() : ((Integer)this.submit(this.pendingTasksCallable).syncUninterruptibly().getNow()).intValue();
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n2) {
        if (n2 <= 0 || n2 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n2 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n2;
    }

    @Override
    protected void cleanup() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the kqueue fd.", iOException);
            }
        }
        finally {
            this.deleteJniChannelPointers();
            this.jniChannelPointers.free();
            this.changeList.free();
            this.eventList.free();
        }
    }

    private void closeAll() {
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void validateScheduled(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toDays(l2);
        if (l3 > 1095L) {
            throw new IllegalArgumentException("days: " + l3 + " (expected: < " + 1095L + ')');
        }
    }

    static /* synthetic */ int access$000(KQueueEventLoop kQueueEventLoop) {
        return kQueueEventLoop.kqueueWaitNow();
    }

    static /* synthetic */ int access$101(KQueueEventLoop kQueueEventLoop) {
        return super.pendingTasks();
    }

    static {
        KQueue.ensureAvailability();
    }
}

