/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.Native;
import io.netty.util.internal.PlatformDependent;

final class KQueueEventArray {
    private static final int KQUEUE_EVENT_SIZE = Native.sizeofKEvent();
    private static final int KQUEUE_IDENT_OFFSET = Native.offsetofKEventIdent();
    private static final int KQUEUE_FILTER_OFFSET = Native.offsetofKEventFilter();
    private static final int KQUEUE_FFLAGS_OFFSET = Native.offsetofKEventFFlags();
    private static final int KQUEUE_FLAGS_OFFSET = Native.offsetofKEventFlags();
    private static final int KQUEUE_DATA_OFFSET = Native.offsetofKeventData();
    private long memoryAddress;
    private int size;
    private int capacity;

    KQueueEventArray(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("capacity must be >= 1 but was " + n2);
        }
        this.memoryAddress = PlatformDependent.allocateMemory(n2 * KQUEUE_EVENT_SIZE);
        this.capacity = n2;
    }

    long memoryAddress() {
        return this.memoryAddress;
    }

    int capacity() {
        return this.capacity;
    }

    int size() {
        return this.size;
    }

    void clear() {
        this.size = 0;
    }

    void evSet(AbstractKQueueChannel abstractKQueueChannel, short s2, short s3, int n2) {
        this.checkSize();
        KQueueEventArray.evSet(this.getKEventOffset(this.size++), abstractKQueueChannel, abstractKQueueChannel.socket.intValue(), s2, s3, n2);
    }

    private void checkSize() {
        if (this.size == this.capacity) {
            this.realloc(true);
        }
    }

    void realloc(boolean bl2) {
        int n2 = this.capacity <= 65536 ? this.capacity << 1 : this.capacity + this.capacity >> 1;
        long l2 = PlatformDependent.reallocateMemory(this.memoryAddress, n2 * KQUEUE_EVENT_SIZE);
        if (l2 != 0L) {
            this.memoryAddress = l2;
            this.capacity = n2;
            return;
        }
        if (bl2) {
            throw new OutOfMemoryError("unable to allocate " + n2 + " new bytes! Existing capacity is: " + this.capacity);
        }
    }

    void free() {
        PlatformDependent.freeMemory(this.memoryAddress);
        this.capacity = 0;
        this.size = 0;
        this.memoryAddress = 0;
    }

    long getKEventOffset(int n2) {
        return this.memoryAddress + (long)(n2 * KQUEUE_EVENT_SIZE);
    }

    short flags(int n2) {
        return PlatformDependent.getShort(this.getKEventOffset(n2) + (long)KQUEUE_FLAGS_OFFSET);
    }

    short filter(int n2) {
        return PlatformDependent.getShort(this.getKEventOffset(n2) + (long)KQUEUE_FILTER_OFFSET);
    }

    short fflags(int n2) {
        return PlatformDependent.getShort(this.getKEventOffset(n2) + (long)KQUEUE_FFLAGS_OFFSET);
    }

    int fd(int n2) {
        return PlatformDependent.getInt(this.getKEventOffset(n2) + (long)KQUEUE_IDENT_OFFSET);
    }

    long data(int n2) {
        return PlatformDependent.getLong(this.getKEventOffset(n2) + (long)KQUEUE_DATA_OFFSET);
    }

    AbstractKQueueChannel channel(int n2) {
        return KQueueEventArray.getChannel(this.getKEventOffset(n2));
    }

    private static native void evSet(long var0, AbstractKQueueChannel var2, int var3, short var4, short var5, int var6);

    private static native AbstractKQueueChannel getChannel(long var0);

    static native void deleteGlobalRefs(long var0, long var2);
}

