/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueDomainSocketChannel$KQueueDomainUnsafe;
import io.netty.channel.kqueue.KQueueDomainSocketChannelConfig;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.DomainSocketChannel;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import java.net.SocketAddress;

public final class KQueueDomainSocketChannel
extends AbstractKQueueStreamChannel
implements DomainSocketChannel {
    private final KQueueDomainSocketChannelConfig config = new KQueueDomainSocketChannelConfig(this);
    private volatile DomainSocketAddress local;
    private volatile DomainSocketAddress remote;

    public KQueueDomainSocketChannel() {
        super(null, BsdSocket.newSocketDomain(), false);
    }

    public KQueueDomainSocketChannel(int n2) {
        this(null, new BsdSocket(n2));
    }

    KQueueDomainSocketChannel(Channel channel, BsdSocket bsdSocket) {
        super(channel, bsdSocket, true);
    }

    @Override
    protected AbstractKQueueChannel$AbstractKQueueUnsafe newUnsafe() {
        return new KQueueDomainSocketChannel$KQueueDomainUnsafe(this, null);
    }

    @Override
    protected DomainSocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected DomainSocketAddress remoteAddress0() {
        return this.remote;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        this.socket.bind(socketAddress);
        this.local = (DomainSocketAddress)socketAddress;
    }

    @Override
    public KQueueDomainSocketChannelConfig config() {
        return this.config;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (super.doConnect(socketAddress, socketAddress2)) {
            this.local = (DomainSocketAddress)socketAddress2;
            this.remote = (DomainSocketAddress)socketAddress;
            return true;
        }
        return false;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    public DomainSocketAddress localAddress() {
        return (DomainSocketAddress)super.localAddress();
    }

    @Override
    protected int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof FileDescriptor && this.socket.sendFd(((FileDescriptor)object).intValue()) > 0) {
            channelOutboundBuffer.remove();
            return 1;
        }
        return super.doWriteSingle(channelOutboundBuffer);
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        if (object instanceof FileDescriptor) {
            return object;
        }
        return super.filterOutboundMessage(object);
    }

    public PeerCredentials peerCredentials() {
        return this.socket.getPeerCredentials();
    }
}

