/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.unix.UnixChannelOption;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Map;

public final class KQueueDatagramChannelConfig
extends KQueueChannelConfig
implements DatagramChannelConfig {
    private static final RecvByteBufAllocator DEFAULT_RCVBUF_ALLOCATOR = new FixedRecvByteBufAllocator(2048);
    private final KQueueDatagramChannel datagramChannel;
    private boolean activeOnOpen;

    KQueueDatagramChannelConfig(KQueueDatagramChannel kQueueDatagramChannel) {
        super(kQueueDatagramChannel);
        this.datagramChannel = kQueueDatagramChannel;
        this.setRecvByteBufAllocator(DEFAULT_RCVBUF_ALLOCATOR);
    }

    @Override
    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), ChannelOption.SO_BROADCAST, ChannelOption.SO_RCVBUF, ChannelOption.SO_SNDBUF, ChannelOption.SO_REUSEADDR, ChannelOption.IP_MULTICAST_LOOP_DISABLED, ChannelOption.IP_MULTICAST_ADDR, ChannelOption.IP_MULTICAST_IF, ChannelOption.IP_MULTICAST_TTL, ChannelOption.IP_TOS, ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, UnixChannelOption.SO_REUSEPORT);
    }

    @Override
    public <T> T getOption(ChannelOption<T> channelOption) {
        if (channelOption == ChannelOption.SO_BROADCAST) {
            return (T)Boolean.valueOf(this.isBroadcast());
        }
        if (channelOption == ChannelOption.SO_RCVBUF) {
            return (T)Integer.valueOf(this.getReceiveBufferSize());
        }
        if (channelOption == ChannelOption.SO_SNDBUF) {
            return (T)Integer.valueOf(this.getSendBufferSize());
        }
        if (channelOption == ChannelOption.SO_REUSEADDR) {
            return (T)Boolean.valueOf(this.isReuseAddress());
        }
        if (channelOption == ChannelOption.IP_MULTICAST_LOOP_DISABLED) {
            return (T)Boolean.valueOf(this.isLoopbackModeDisabled());
        }
        if (channelOption == ChannelOption.IP_MULTICAST_ADDR) {
            return (T)this.getInterface();
        }
        if (channelOption == ChannelOption.IP_MULTICAST_IF) {
            return (T)this.getNetworkInterface();
        }
        if (channelOption == ChannelOption.IP_MULTICAST_TTL) {
            return (T)Integer.valueOf(this.getTimeToLive());
        }
        if (channelOption == ChannelOption.IP_TOS) {
            return (T)Integer.valueOf(this.getTrafficClass());
        }
        if (channelOption == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            return (T)Boolean.valueOf(this.activeOnOpen);
        }
        if (channelOption == UnixChannelOption.SO_REUSEPORT) {
            return (T)Boolean.valueOf(this.isReusePort());
        }
        return super.getOption(channelOption);
    }

    @Override
    public <T> boolean setOption(ChannelOption<T> channelOption, T t2) {
        this.validate(channelOption, t2);
        if (channelOption == ChannelOption.SO_BROADCAST) {
            this.setBroadcast((Boolean)t2);
        } else if (channelOption == ChannelOption.SO_RCVBUF) {
            this.setReceiveBufferSize((Integer)t2);
        } else if (channelOption == ChannelOption.SO_SNDBUF) {
            this.setSendBufferSize((Integer)t2);
        } else if (channelOption == ChannelOption.SO_REUSEADDR) {
            this.setReuseAddress((Boolean)t2);
        } else if (channelOption == ChannelOption.IP_MULTICAST_LOOP_DISABLED) {
            this.setLoopbackModeDisabled((Boolean)t2);
        } else if (channelOption == ChannelOption.IP_MULTICAST_ADDR) {
            this.setInterface((InetAddress)t2);
        } else if (channelOption == ChannelOption.IP_MULTICAST_IF) {
            this.setNetworkInterface((NetworkInterface)t2);
        } else if (channelOption == ChannelOption.IP_MULTICAST_TTL) {
            this.setTimeToLive((Integer)t2);
        } else if (channelOption == ChannelOption.IP_TOS) {
            this.setTrafficClass((Integer)t2);
        } else if (channelOption == ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) {
            this.setActiveOnOpen((Boolean)t2);
        } else if (channelOption == UnixChannelOption.SO_REUSEPORT) {
            this.setReusePort((Boolean)t2);
        } else {
            return super.setOption(channelOption, t2);
        }
        return true;
    }

    private void setActiveOnOpen(boolean bl2) {
        if (this.channel.isRegistered()) {
            throw new IllegalStateException("Can only changed before channel was registered");
        }
        this.activeOnOpen = bl2;
    }

    boolean getActiveOnOpen() {
        return this.activeOnOpen;
    }

    public boolean isReusePort() {
        try {
            return this.datagramChannel.socket.isReusePort();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    public KQueueDatagramChannelConfig setReusePort(boolean bl2) {
        try {
            this.datagramChannel.socket.setReusePort(bl2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public KQueueDatagramChannelConfig setRcvAllocTransportProvidesGuess(boolean bl2) {
        super.setRcvAllocTransportProvidesGuess(bl2);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setMessageSizeEstimator(MessageSizeEstimator messageSizeEstimator) {
        super.setMessageSizeEstimator(messageSizeEstimator);
        return this;
    }

    @Override
    @Deprecated
    public KQueueDatagramChannelConfig setWriteBufferLowWaterMark(int n2) {
        super.setWriteBufferLowWaterMark(n2);
        return this;
    }

    @Override
    @Deprecated
    public KQueueDatagramChannelConfig setWriteBufferHighWaterMark(int n2) {
        super.setWriteBufferHighWaterMark(n2);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setWriteBufferWaterMark(WriteBufferWaterMark writeBufferWaterMark) {
        super.setWriteBufferWaterMark(writeBufferWaterMark);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setAutoClose(boolean bl2) {
        super.setAutoClose(bl2);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setAutoRead(boolean bl2) {
        super.setAutoRead(bl2);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setRecvByteBufAllocator(RecvByteBufAllocator recvByteBufAllocator) {
        super.setRecvByteBufAllocator(recvByteBufAllocator);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setWriteSpinCount(int n2) {
        super.setWriteSpinCount(n2);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setAllocator(ByteBufAllocator byteBufAllocator) {
        super.setAllocator(byteBufAllocator);
        return this;
    }

    @Override
    public KQueueDatagramChannelConfig setConnectTimeoutMillis(int n2) {
        super.setConnectTimeoutMillis(n2);
        return this;
    }

    @Override
    @Deprecated
    public KQueueDatagramChannelConfig setMaxMessagesPerRead(int n2) {
        super.setMaxMessagesPerRead(n2);
        return this;
    }

    @Override
    public int getSendBufferSize() {
        try {
            return this.datagramChannel.socket.getSendBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public KQueueDatagramChannelConfig setSendBufferSize(int n2) {
        try {
            this.datagramChannel.socket.setSendBufferSize(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getReceiveBufferSize() {
        try {
            return this.datagramChannel.socket.getReceiveBufferSize();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public KQueueDatagramChannelConfig setReceiveBufferSize(int n2) {
        try {
            this.datagramChannel.socket.setReceiveBufferSize(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public int getTrafficClass() {
        try {
            return this.datagramChannel.socket.getTrafficClass();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public KQueueDatagramChannelConfig setTrafficClass(int n2) {
        try {
            this.datagramChannel.socket.setTrafficClass(n2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isReuseAddress() {
        try {
            return this.datagramChannel.socket.isReuseAddress();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public KQueueDatagramChannelConfig setReuseAddress(boolean bl2) {
        try {
            this.datagramChannel.socket.setReuseAddress(bl2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isBroadcast() {
        try {
            return this.datagramChannel.socket.isBroadcast();
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public KQueueDatagramChannelConfig setBroadcast(boolean bl2) {
        try {
            this.datagramChannel.socket.setBroadcast(bl2);
            return this;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public boolean isLoopbackModeDisabled() {
        return false;
    }

    @Override
    public DatagramChannelConfig setLoopbackModeDisabled(boolean bl2) {
        throw new UnsupportedOperationException("Multicast not supported");
    }

    @Override
    public int getTimeToLive() {
        return -1;
    }

    @Override
    public KQueueDatagramChannelConfig setTimeToLive(int n2) {
        throw new UnsupportedOperationException("Multicast not supported");
    }

    @Override
    public InetAddress getInterface() {
        return null;
    }

    @Override
    public KQueueDatagramChannelConfig setInterface(InetAddress inetAddress) {
        throw new UnsupportedOperationException("Multicast not supported");
    }

    @Override
    public NetworkInterface getNetworkInterface() {
        return null;
    }

    @Override
    public KQueueDatagramChannelConfig setNetworkInterface(NetworkInterface networkInterface) {
        throw new UnsupportedOperationException("Multicast not supported");
    }
}

