/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.kqueue.AcceptFilter;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.Errors$NativeIoException;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.ThrowableUtil;
import java.nio.channels.ClosedChannelException;

final class BsdSocket
extends Socket {
    private static final Errors$NativeIoException SENDFILE_CONNECTION_RESET_EXCEPTION;
    private static final ClosedChannelException SENDFILE_CLOSED_CHANNEL_EXCEPTION;
    private static final int APPLE_SND_LOW_AT_MAX = 131072;
    private static final int FREEBSD_SND_LOW_AT_MAX = 32768;
    static final int BSD_SND_LOW_AT_MAX;

    BsdSocket(int n2) {
        super(n2);
    }

    void setAcceptFilter(AcceptFilter acceptFilter) {
        BsdSocket.setAcceptFilter(this.intValue(), acceptFilter.filterName(), acceptFilter.filterArgs());
    }

    void setTcpNoPush(boolean bl2) {
        BsdSocket.setTcpNoPush(this.intValue(), bl2 ? 1 : 0);
    }

    void setSndLowAt(int n2) {
        BsdSocket.setSndLowAt(this.intValue(), n2);
    }

    boolean isTcpNoPush() {
        return BsdSocket.getTcpNoPush(this.intValue()) != 0;
    }

    int getSndLowAt() {
        return BsdSocket.getSndLowAt(this.intValue());
    }

    AcceptFilter getAcceptFilter() {
        String[] stringArray = BsdSocket.getAcceptFilter(this.intValue());
        return stringArray == null ? AcceptFilter.PLATFORM_UNSUPPORTED : new AcceptFilter(stringArray[0], stringArray[1]);
    }

    PeerCredentials getPeerCredentials() {
        return BsdSocket.getPeerCredentials(this.intValue());
    }

    long sendFile(DefaultFileRegion defaultFileRegion, long l2, long l3, long l4) {
        defaultFileRegion.open();
        long l5 = BsdSocket.sendFile(this.intValue(), defaultFileRegion, l2, l3, l4);
        if (l5 >= 0L) {
            return l5;
        }
        return Errors.ioResult("sendfile", (int)l5, SENDFILE_CONNECTION_RESET_EXCEPTION, SENDFILE_CLOSED_CHANNEL_EXCEPTION);
    }

    public static BsdSocket newSocketStream() {
        return new BsdSocket(BsdSocket.newSocketStream0());
    }

    public static BsdSocket newSocketDgram() {
        return new BsdSocket(BsdSocket.newSocketDgram0());
    }

    public static BsdSocket newSocketDomain() {
        return new BsdSocket(BsdSocket.newSocketDomain0());
    }

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6);

    private static native String[] getAcceptFilter(int var0);

    private static native int getTcpNoPush(int var0);

    private static native int getSndLowAt(int var0);

    private static native PeerCredentials getPeerCredentials(int var0);

    private static native void setAcceptFilter(int var0, String var1, String var2);

    private static native void setTcpNoPush(int var0, int var1);

    private static native void setSndLowAt(int var0, int var1);

    static {
        SENDFILE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Native.class, "sendfile(..)");
        BSD_SND_LOW_AT_MAX = Math.min(131072, 32768);
        SENDFILE_CONNECTION_RESET_EXCEPTION = Errors.newConnectionResetException("syscall:sendfile", Errors.ERRNO_EPIPE_NEGATIVE);
    }
}

