/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.FileRegion;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$1;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$2;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$3;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$4;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$5;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$KQueueSocketWritableByteChannel;
import io.netty.channel.kqueue.AbstractKQueueStreamChannel$KQueueStreamUnsafe;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.IovArray;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class AbstractKQueueStreamChannel
extends AbstractKQueueChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractKQueueStreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(DefaultFileRegion.class) + ')';
    private WritableByteChannel byteChannel;
    private final Runnable flushTask = new AbstractKQueueStreamChannel$1(this);

    AbstractKQueueStreamChannel(Channel channel, BsdSocket bsdSocket, boolean bl2) {
        super(channel, bsdSocket, bl2);
    }

    AbstractKQueueStreamChannel(Channel channel, BsdSocket bsdSocket, SocketAddress socketAddress) {
        super(channel, bsdSocket, socketAddress);
    }

    AbstractKQueueStreamChannel(BsdSocket bsdSocket) {
        this(null, bsdSocket, AbstractKQueueStreamChannel.isSoErrorZero(bsdSocket));
    }

    @Override
    protected AbstractKQueueChannel$AbstractKQueueUnsafe newUnsafe() {
        return new AbstractKQueueStreamChannel$KQueueStreamUnsafe(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    private int writeBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (byteBuf.hasMemoryAddress() || byteBuf.nioBufferCount() == 1) {
            return this.doWriteBytes(channelOutboundBuffer, byteBuf);
        }
        ByteBuffer[] byteBufferArray = byteBuf.nioBuffers();
        return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, byteBufferArray.length, n2, this.config().getMaxBytesPerGatheringWrite());
    }

    private void adjustMaxBytesPerGatheringWrite(long l2, long l3, long l4) {
        if (l2 == l3) {
            if (l2 << 1 > l4) {
                this.config().setMaxBytesPerGatheringWrite(l2 << 1);
            }
        } else if (l2 > 4096L && l3 < l2 >>> 1) {
            this.config().setMaxBytesPerGatheringWrite(l2 >>> 1);
        }
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, IovArray iovArray) {
        long l2 = iovArray.size();
        assert (l2 != 0L);
        int n2 = iovArray.count();
        assert (n2 != 0);
        long l3 = this.socket.writevAddresses(iovArray.memoryAddress(0), n2);
        if (l3 > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l2, l3, iovArray.maxBytes());
            channelOutboundBuffer.removeBytes(l3);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeBytesMultiple(ChannelOutboundBuffer channelOutboundBuffer, ByteBuffer[] byteBufferArray, int n2, long l2, long l3) {
        long l4;
        assert (l2 != 0L);
        if (l2 > l3) {
            l2 = l3;
        }
        if ((l4 = this.socket.writev(byteBufferArray, 0, n2, l2)) > 0L) {
            this.adjustMaxBytesPerGatheringWrite(l2, l4, l3);
            channelOutboundBuffer.removeBytes(l4);
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeDefaultFileRegion(ChannelOutboundBuffer channelOutboundBuffer, DefaultFileRegion defaultFileRegion) {
        long l2 = defaultFileRegion.count();
        if (defaultFileRegion.transferred() >= l2) {
            channelOutboundBuffer.remove();
            return 0;
        }
        long l3 = defaultFileRegion.transferred();
        long l4 = this.socket.sendFile(defaultFileRegion, defaultFileRegion.position(), l3, l2 - l3);
        if (l4 > 0L) {
            channelOutboundBuffer.progress(l4);
            if (defaultFileRegion.transferred() >= l2) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    private int writeFileRegion(ChannelOutboundBuffer channelOutboundBuffer, FileRegion fileRegion) {
        long l2;
        if (fileRegion.transferred() >= fileRegion.count()) {
            channelOutboundBuffer.remove();
            return 0;
        }
        if (this.byteChannel == null) {
            this.byteChannel = new AbstractKQueueStreamChannel$KQueueSocketWritableByteChannel(this);
        }
        if ((l2 = fileRegion.transferTo(this.byteChannel, fileRegion.transferred())) > 0L) {
            channelOutboundBuffer.progress(l2);
            if (fileRegion.transferred() >= fileRegion.count()) {
                channelOutboundBuffer.remove();
            }
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        int n2 = this.config().getWriteSpinCount();
        do {
            int n3;
            if ((n3 = channelOutboundBuffer.size()) > 1 && channelOutboundBuffer.current() instanceof ByteBuf) {
                n2 -= this.doWriteMultiple(channelOutboundBuffer);
                continue;
            }
            if (n3 == 0) {
                this.writeFilter(false);
                return;
            }
            n2 -= this.doWriteSingle(channelOutboundBuffer);
        } while (n2 > 0);
        if (n2 == 0) {
            this.writeFilter(false);
            this.eventLoop().execute(this.flushTask);
        } else {
            this.writeFilter(true);
        }
    }

    protected int doWriteSingle(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object = channelOutboundBuffer.current();
        if (object instanceof ByteBuf) {
            return this.writeBytes(channelOutboundBuffer, (ByteBuf)object);
        }
        if (object instanceof DefaultFileRegion) {
            return this.writeDefaultFileRegion(channelOutboundBuffer, (DefaultFileRegion)object);
        }
        if (object instanceof FileRegion) {
            return this.writeFileRegion(channelOutboundBuffer, (FileRegion)object);
        }
        throw new Error();
    }

    private int doWriteMultiple(ChannelOutboundBuffer channelOutboundBuffer) {
        long l2 = this.config().getMaxBytesPerGatheringWrite();
        if (PlatformDependent.hasUnsafe()) {
            IovArray iovArray = ((KQueueEventLoop)this.eventLoop()).cleanArray();
            iovArray.maxBytes(l2);
            channelOutboundBuffer.forEachFlushedMessage(iovArray);
            if (iovArray.count() >= 1) {
                return this.writeBytesMultiple(channelOutboundBuffer, iovArray);
            }
        } else {
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers();
            int n2 = channelOutboundBuffer.nioBufferCount();
            if (n2 >= 1) {
                return this.writeBytesMultiple(channelOutboundBuffer, byteBufferArray, n2, channelOutboundBuffer.nioBufferSize(), l2);
            }
        }
        channelOutboundBuffer.removeBytes(0L);
        return 0;
    }

    @Override
    protected Object filterOutboundMessage(Object object) {
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            return UnixChannelUtil.isBufferCopyNeededForWrite(byteBuf) ? this.newDirectBuffer(byteBuf) : byteBuf;
        }
        if (object instanceof FileRegion) {
            return object;
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(object) + EXPECTED_TYPES);
    }

    @Override
    protected final void doShutdownOutput() {
        this.socket.shutdown(false, true);
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.socket.isShutdown();
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            ((AbstractChannel$AbstractUnsafe)this.unsafe()).shutdownOutput(channelPromise);
        } else {
            eventLoop.execute(new AbstractKQueueStreamChannel$2(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownInput(ChannelPromise channelPromise) {
        EventLoop eventLoop = this.eventLoop();
        if (eventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            eventLoop.execute(new AbstractKQueueStreamChannel$3(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.socket.shutdown(true, false);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
            return;
        }
        channelPromise.setSuccess();
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new AbstractKQueueStreamChannel$4(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownOutputDone(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            AbstractKQueueStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener(new AbstractKQueueStreamChannel$5(this, channelFuture, channelPromise));
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    static /* synthetic */ void access$000(AbstractKQueueStreamChannel abstractKQueueStreamChannel, ChannelPromise channelPromise) {
        abstractKQueueStreamChannel.shutdownInput0(channelPromise);
    }

    static /* synthetic */ void access$100(AbstractKQueueStreamChannel abstractKQueueStreamChannel, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        abstractKQueueStreamChannel.shutdownOutputDone(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$200(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        AbstractKQueueStreamChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
    }
}

