/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.kqueue.AbstractKQueueChannel$1;
import io.netty.channel.kqueue.AbstractKQueueChannel$2;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe;
import io.netty.channel.kqueue.BsdSocket;
import io.netty.channel.kqueue.KQueueChannelConfig;
import io.netty.channel.kqueue.KQueueEventLoop;
import io.netty.channel.kqueue.Native;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.ScheduledFuture;

abstract class AbstractKQueueChannel
extends AbstractChannel
implements UnixChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    final BsdSocket socket;
    private boolean readFilterEnabled = true;
    private boolean writeFilterEnabled;
    boolean readReadyRunnablePending;
    boolean inputClosedSeenErrorOnRead;
    long jniSelfPtr;
    protected volatile boolean active;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;

    AbstractKQueueChannel(Channel channel, BsdSocket bsdSocket, boolean bl2) {
        super(channel);
        this.socket = ObjectUtil.checkNotNull(bsdSocket, "fd");
        this.active = bl2;
        if (bl2) {
            this.local = bsdSocket.localAddress();
            this.remote = bsdSocket.remoteAddress();
        }
    }

    AbstractKQueueChannel(Channel channel, BsdSocket bsdSocket, SocketAddress socketAddress) {
        super(channel);
        this.socket = ObjectUtil.checkNotNull(bsdSocket, "fd");
        this.active = true;
        this.remote = socketAddress;
        this.local = bsdSocket.localAddress();
    }

    static boolean isSoErrorZero(BsdSocket bsdSocket) {
        try {
            return bsdSocket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    @Override
    public final FileDescriptor fd() {
        return this.socket;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected void doClose() {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        try {
            if (this.isRegistered()) {
                EventLoop eventLoop = this.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.doDeregister();
                } else {
                    eventLoop.execute(new AbstractKQueueChannel$1(this));
                }
            }
        }
        finally {
            this.socket.close();
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof KQueueEventLoop;
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }

    @Override
    protected void doDeregister() {
        this.readFilter(false);
        this.writeFilter(false);
        this.evSet0(Native.EVFILT_SOCK, Native.EV_DELETE, 0);
        ((KQueueEventLoop)this.eventLoop()).remove(this);
        this.readFilterEnabled = true;
    }

    @Override
    protected final void doBeginRead() {
        AbstractKQueueChannel$AbstractKQueueUnsafe abstractKQueueChannel$AbstractKQueueUnsafe = (AbstractKQueueChannel$AbstractKQueueUnsafe)this.unsafe();
        abstractKQueueChannel$AbstractKQueueUnsafe.readPending = true;
        this.readFilter(true);
        if (abstractKQueueChannel$AbstractKQueueUnsafe.maybeMoreDataToRead) {
            abstractKQueueChannel$AbstractKQueueUnsafe.executeReadReadyRunnable(this.config());
        }
    }

    @Override
    protected void doRegister() {
        this.readReadyRunnablePending = false;
        if (this.writeFilterEnabled) {
            this.evSet0(Native.EVFILT_WRITE, Native.EV_ADD_CLEAR_ENABLE);
        }
        if (this.readFilterEnabled) {
            this.evSet0(Native.EVFILT_READ, Native.EV_ADD_CLEAR_ENABLE);
        }
        this.evSet0(Native.EVFILT_SOCK, Native.EV_ADD, Native.NOTE_RDHUP);
    }

    @Override
    protected abstract AbstractKQueueChannel$AbstractKQueueUnsafe newUnsafe();

    @Override
    public abstract KQueueChannelConfig config();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        return this.newDirectBuffer(byteBuf, byteBuf);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.release(object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractKQueueChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n2);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractKQueueChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n2);
        }
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, int n2) {
        ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n2);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            n2 = this.socket.readAddress(byteBuf.memoryAddress(), n3, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n3, byteBuf.writableBytes());
            n2 = this.socket.read(byteBuffer, byteBuffer.position(), byteBuffer.limit());
        }
        if (n2 > 0) {
            byteBuf.writerIndex(n3 + n2);
        }
        return n2;
    }

    protected final int doWriteBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        if (byteBuf.hasMemoryAddress()) {
            int n2 = this.socket.writeAddress(byteBuf.memoryAddress(), byteBuf.readerIndex(), byteBuf.writerIndex());
            if (n2 > 0) {
                channelOutboundBuffer.removeBytes(n2);
                return 1;
            }
        } else {
            ByteBuffer byteBuffer = byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()) : byteBuf.nioBuffer();
            int n3 = this.socket.write(byteBuffer, byteBuffer.position(), byteBuffer.limit());
            if (n3 > 0) {
                byteBuffer.position(byteBuffer.position() + n3);
                channelOutboundBuffer.removeBytes(n3);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    final boolean shouldBreakReadReady(ChannelConfig channelConfig) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractKQueueChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    final void clearReadFilter() {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            AbstractKQueueChannel$AbstractKQueueUnsafe abstractKQueueChannel$AbstractKQueueUnsafe = (AbstractKQueueChannel$AbstractKQueueUnsafe)this.unsafe();
            if (eventLoop.inEventLoop()) {
                abstractKQueueChannel$AbstractKQueueUnsafe.clearReadFilter0();
            } else {
                eventLoop.execute(new AbstractKQueueChannel$2(this, abstractKQueueChannel$AbstractKQueueUnsafe));
            }
        } else {
            this.readFilterEnabled = false;
        }
    }

    void readFilter(boolean bl2) {
        if (this.readFilterEnabled != bl2) {
            this.readFilterEnabled = bl2;
            this.evSet(Native.EVFILT_READ, bl2 ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    void writeFilter(boolean bl2) {
        if (this.writeFilterEnabled != bl2) {
            this.writeFilterEnabled = bl2;
            this.evSet(Native.EVFILT_WRITE, bl2 ? Native.EV_ADD_CLEAR_ENABLE : Native.EV_DELETE_DISABLE);
        }
    }

    private void evSet(short s2, short s3) {
        if (this.isOpen() && this.isRegistered()) {
            this.evSet0(s2, s3);
        }
    }

    private void evSet0(short s2, short s3) {
        this.evSet0(s2, s3, 0);
    }

    private void evSet0(short s2, short s3, int n2) {
        ((KQueueEventLoop)this.eventLoop()).evSet(this, s2, s3, n2);
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)socketAddress);
        }
        this.socket.bind(socketAddress);
        this.local = this.socket.localAddress();
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        boolean bl2;
        InetSocketAddress inetSocketAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            AbstractKQueueChannel.checkResolvable((InetSocketAddress)socketAddress2);
        }
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            AbstractKQueueChannel.checkResolvable(inetSocketAddress);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (socketAddress2 != null) {
            this.socket.bind(socketAddress2);
        }
        if (bl2 = this.doConnect0(socketAddress)) {
            this.remote = inetSocketAddress == null ? socketAddress : UnixChannelUtil.computeRemoteAddr(inetSocketAddress, this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect0(SocketAddress socketAddress) {
        boolean bl2 = false;
        try {
            boolean bl3 = this.socket.connect(socketAddress);
            if (!bl3) {
                this.writeFilter(true);
            }
            bl2 = true;
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (!bl2) {
                this.doClose();
            }
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    static /* synthetic */ ChannelPromise access$000(AbstractKQueueChannel abstractKQueueChannel) {
        return abstractKQueueChannel.connectPromise;
    }

    static /* synthetic */ ChannelPromise access$002(AbstractKQueueChannel abstractKQueueChannel, ChannelPromise channelPromise) {
        abstractKQueueChannel.connectPromise = channelPromise;
        return abstractKQueueChannel.connectPromise;
    }

    static /* synthetic */ boolean access$100(ChannelConfig channelConfig) {
        return AbstractKQueueChannel.isAllowHalfClosure(channelConfig);
    }

    static /* synthetic */ boolean access$200(AbstractKQueueChannel abstractKQueueChannel) {
        return abstractKQueueChannel.writeFilterEnabled;
    }

    static /* synthetic */ SocketAddress access$302(AbstractKQueueChannel abstractKQueueChannel, SocketAddress socketAddress) {
        abstractKQueueChannel.requestedRemoteAddress = socketAddress;
        return abstractKQueueChannel.requestedRemoteAddress;
    }

    static /* synthetic */ ScheduledFuture access$402(AbstractKQueueChannel abstractKQueueChannel, ScheduledFuture scheduledFuture) {
        abstractKQueueChannel.connectTimeoutFuture = scheduledFuture;
        return abstractKQueueChannel.connectTimeoutFuture;
    }

    static /* synthetic */ ScheduledFuture access$400(AbstractKQueueChannel abstractKQueueChannel) {
        return abstractKQueueChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$300(AbstractKQueueChannel abstractKQueueChannel) {
        return abstractKQueueChannel.requestedRemoteAddress;
    }

    static /* synthetic */ SocketAddress access$502(AbstractKQueueChannel abstractKQueueChannel, SocketAddress socketAddress) {
        abstractKQueueChannel.remote = socketAddress;
        return abstractKQueueChannel.remote;
    }
}

