/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.AbstractChannel$AbstractUnsafe;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPromise;
import io.netty.channel.RecvByteBufAllocator$ExtendedHandle;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe$1;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe$2;
import io.netty.channel.kqueue.AbstractKQueueChannel$AbstractKQueueUnsafe$3;
import io.netty.channel.kqueue.KQueueRecvByteAllocatorHandle;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.unix.UnixChannelUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.TimeUnit;

abstract class AbstractKQueueChannel$AbstractKQueueUnsafe
extends AbstractChannel$AbstractUnsafe {
    boolean readPending;
    boolean maybeMoreDataToRead;
    private KQueueRecvByteAllocatorHandle allocHandle;
    private final Runnable readReadyRunnable;
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ AbstractKQueueChannel this$0;

    AbstractKQueueChannel$AbstractKQueueUnsafe(AbstractKQueueChannel abstractKQueueChannel) {
        this.this$0 = abstractKQueueChannel;
        super(abstractKQueueChannel);
        this.readReadyRunnable = new AbstractKQueueChannel$AbstractKQueueUnsafe$1(this);
    }

    final void readReady(long l2) {
        KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle = this.recvBufAllocHandle();
        kQueueRecvByteAllocatorHandle.numberBytesPending(l2);
        this.readReady(kQueueRecvByteAllocatorHandle);
    }

    abstract void readReady(KQueueRecvByteAllocatorHandle var1);

    final void readReadyBefore() {
        this.maybeMoreDataToRead = false;
    }

    final void readReadyFinally(ChannelConfig channelConfig) {
        this.maybeMoreDataToRead = this.allocHandle.maybeMoreDataToRead();
        if (!this.readPending && !channelConfig.isAutoRead()) {
            this.clearReadFilter0();
        } else if (this.readPending && this.maybeMoreDataToRead) {
            this.executeReadReadyRunnable(channelConfig);
        }
    }

    final boolean failConnectPromise(Throwable throwable) {
        if (AbstractKQueueChannel.access$000(this.this$0) != null) {
            ChannelPromise channelPromise = AbstractKQueueChannel.access$000(this.this$0);
            AbstractKQueueChannel.access$002(this.this$0, null);
            if (channelPromise.tryFailure(throwable instanceof ConnectException ? throwable : new ConnectException("failed to connect").initCause(throwable))) {
                this.closeIfClosed();
                return true;
            }
        }
        return false;
    }

    final void writeReady() {
        if (AbstractKQueueChannel.access$000(this.this$0) != null) {
            this.finishConnect();
        } else if (!this.this$0.socket.isOutputShutdown()) {
            super.flush0();
        }
    }

    void shutdownInput(boolean bl2) {
        if (bl2 && AbstractKQueueChannel.access$000(this.this$0) != null) {
            this.finishConnect();
        }
        if (!this.this$0.socket.isInputShutdown()) {
            if (AbstractKQueueChannel.access$100(this.this$0.config())) {
                try {
                    this.this$0.socket.shutdown(true, false);
                }
                catch (IOException iOException) {
                    this.fireEventAndClose(ChannelInputShutdownEvent.INSTANCE);
                    return;
                }
                catch (NotYetConnectedException notYetConnectedException) {
                    // empty catch block
                }
                this.this$0.pipeline().fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
            } else {
                this.close(this.voidPromise());
            }
        } else if (!bl2) {
            this.this$0.inputClosedSeenErrorOnRead = true;
            this.this$0.pipeline().fireUserEventTriggered(ChannelInputShutdownReadComplete.INSTANCE);
        }
    }

    final void readEOF() {
        KQueueRecvByteAllocatorHandle kQueueRecvByteAllocatorHandle = this.recvBufAllocHandle();
        kQueueRecvByteAllocatorHandle.readEOF();
        if (this.this$0.isActive()) {
            this.readReady(kQueueRecvByteAllocatorHandle);
        } else {
            this.shutdownInput(true);
        }
    }

    @Override
    public KQueueRecvByteAllocatorHandle recvBufAllocHandle() {
        if (this.allocHandle == null) {
            this.allocHandle = new KQueueRecvByteAllocatorHandle((RecvByteBufAllocator$ExtendedHandle)super.recvBufAllocHandle());
        }
        return this.allocHandle;
    }

    @Override
    protected final void flush0() {
        if (!AbstractKQueueChannel.access$200(this.this$0)) {
            super.flush0();
        }
    }

    final void executeReadReadyRunnable(ChannelConfig channelConfig) {
        if (this.this$0.readReadyRunnablePending || !this.this$0.isActive() || this.this$0.shouldBreakReadReady(channelConfig)) {
            return;
        }
        this.this$0.readReadyRunnablePending = true;
        this.this$0.eventLoop().execute(this.readReadyRunnable);
    }

    protected final void clearReadFilter0() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        try {
            this.readPending = false;
            this.this$0.readFilter(false);
        }
        catch (IOException iOException) {
            this.this$0.pipeline().fireExceptionCaught(iOException);
            this.this$0.unsafe().close(this.this$0.unsafe().voidPromise());
        }
    }

    private void fireEventAndClose(Object object) {
        this.this$0.pipeline().fireUserEventTriggered(object);
        this.close(this.voidPromise());
    }

    @Override
    public void connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        if (!channelPromise.setUncancellable() || !this.ensureOpen(channelPromise)) {
            return;
        }
        try {
            if (AbstractKQueueChannel.access$000(this.this$0) != null) {
                throw new ConnectionPendingException();
            }
            boolean bl2 = this.this$0.isActive();
            if (this.this$0.doConnect(socketAddress, socketAddress2)) {
                this.fulfillConnectPromise(channelPromise, bl2);
            } else {
                AbstractKQueueChannel.access$002(this.this$0, channelPromise);
                AbstractKQueueChannel.access$302(this.this$0, socketAddress);
                int n2 = this.this$0.config().getConnectTimeoutMillis();
                if (n2 > 0) {
                    AbstractKQueueChannel.access$402(this.this$0, this.this$0.eventLoop().schedule(new AbstractKQueueChannel$AbstractKQueueUnsafe$2(this, socketAddress), (long)n2, TimeUnit.MILLISECONDS));
                }
                channelPromise.addListener(new AbstractKQueueChannel$AbstractKQueueUnsafe$3(this));
            }
        }
        catch (Throwable throwable) {
            this.closeIfClosed();
            channelPromise.tryFailure(this.annotateConnectException(throwable, socketAddress));
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, boolean bl2) {
        if (channelPromise == null) {
            return;
        }
        this.this$0.active = true;
        boolean bl3 = this.this$0.isActive();
        boolean bl4 = channelPromise.trySuccess();
        if (!bl2 && bl3) {
            this.this$0.pipeline().fireChannelActive();
        }
        if (!bl4) {
            this.close(this.voidPromise());
        }
    }

    private void fulfillConnectPromise(ChannelPromise channelPromise, Throwable throwable) {
        if (channelPromise == null) {
            return;
        }
        channelPromise.tryFailure(throwable);
        this.closeIfClosed();
    }

    private void finishConnect() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        boolean bl2 = false;
        try {
            boolean bl3 = this.this$0.isActive();
            if (!this.doFinishConnect()) {
                bl2 = true;
                return;
            }
            this.fulfillConnectPromise(AbstractKQueueChannel.access$000(this.this$0), bl3);
        }
        catch (Throwable throwable) {
            this.fulfillConnectPromise(AbstractKQueueChannel.access$000(this.this$0), this.annotateConnectException(throwable, AbstractKQueueChannel.access$300(this.this$0)));
        }
        finally {
            if (!bl2) {
                if (AbstractKQueueChannel.access$400(this.this$0) != null) {
                    AbstractKQueueChannel.access$400(this.this$0).cancel(false);
                }
                AbstractKQueueChannel.access$002(this.this$0, null);
            }
        }
    }

    private boolean doFinishConnect() {
        if (this.this$0.socket.finishConnect()) {
            this.this$0.writeFilter(false);
            if (AbstractKQueueChannel.access$300(this.this$0) instanceof InetSocketAddress) {
                AbstractKQueueChannel.access$502(this.this$0, UnixChannelUtil.computeRemoteAddr((InetSocketAddress)AbstractKQueueChannel.access$300(this.this$0), this.this$0.socket.remoteAddress()));
            }
            AbstractKQueueChannel.access$302(this.this$0, null);
            return true;
        }
        this.this$0.writeFilter(true);
        return false;
    }

    static {
        $assertionsDisabled = !AbstractKQueueChannel.class.desiredAssertionStatus();
    }
}

