/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelOutboundBuffer$MessageProcessor;
import io.netty.channel.epoll.NativeDatagramPacketArray$1;
import io.netty.channel.epoll.NativeDatagramPacketArray$NativeDatagramPacket;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.Limits;
import io.netty.util.concurrent.FastThreadLocal;
import java.net.InetSocketAddress;

final class NativeDatagramPacketArray
implements ChannelOutboundBuffer$MessageProcessor {
    private static final FastThreadLocal<NativeDatagramPacketArray> ARRAY = new NativeDatagramPacketArray$1();
    private final NativeDatagramPacketArray$NativeDatagramPacket[] packets = new NativeDatagramPacketArray$NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private int count;

    private NativeDatagramPacketArray() {
        for (int i2 = 0; i2 < this.packets.length; ++i2) {
            this.packets[i2] = new NativeDatagramPacketArray$NativeDatagramPacket();
        }
    }

    boolean add(DatagramPacket datagramPacket) {
        if (this.count == this.packets.length) {
            return false;
        }
        ByteBuf byteBuf = (ByteBuf)datagramPacket.content();
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return true;
        }
        NativeDatagramPacketArray$NativeDatagramPacket nativeDatagramPacketArray$NativeDatagramPacket = this.packets[this.count];
        InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.recipient();
        if (!NativeDatagramPacketArray$NativeDatagramPacket.access$300(nativeDatagramPacketArray$NativeDatagramPacket, byteBuf, inetSocketAddress)) {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public boolean processMessage(Object object) {
        return object instanceof DatagramPacket && this.add((DatagramPacket)object);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacketArray$NativeDatagramPacket[] packets() {
        return this.packets;
    }

    static NativeDatagramPacketArray getInstance(ChannelOutboundBuffer channelOutboundBuffer) {
        NativeDatagramPacketArray nativeDatagramPacketArray = ARRAY.get();
        nativeDatagramPacketArray.count = 0;
        channelOutboundBuffer.forEachFlushedMessage(nativeDatagramPacketArray);
        return nativeDatagramPacketArray;
    }

    /* synthetic */ NativeDatagramPacketArray(NativeDatagramPacketArray$1 var1_1) {
        this();
    }

    static /* synthetic */ NativeDatagramPacketArray$NativeDatagramPacket[] access$100(NativeDatagramPacketArray nativeDatagramPacketArray) {
        return nativeDatagramPacketArray.packets;
    }
}

