/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.epoll.EpollTcpInfo;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.NativeInetAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Socket;
import io.netty.util.internal.ThrowableUtil;
import java.net.InetAddress;
import java.nio.channels.ClosedChannelException;

final class LinuxSocket
extends Socket {
    private static final long MAX_UINT32_T = 0xFFFFFFFFL;
    private static final Errors.NativeIoException SENDFILE_CONNECTION_RESET_EXCEPTION = Errors.newConnectionResetException("syscall:sendfile(...)", Errors.ERRNO_EPIPE_NEGATIVE);
    private static final ClosedChannelException SENDFILE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), Native.class, "sendfile(...)");

    public LinuxSocket(int n2) {
        super(n2);
    }

    void setTcpDeferAccept(int n2) {
        LinuxSocket.setTcpDeferAccept(this.intValue(), n2);
    }

    void setTcpQuickAck(boolean bl2) {
        LinuxSocket.setTcpQuickAck(this.intValue(), bl2 ? 1 : 0);
    }

    void setTcpCork(boolean bl2) {
        LinuxSocket.setTcpCork(this.intValue(), bl2 ? 1 : 0);
    }

    void setTcpNotSentLowAt(long l2) {
        if (l2 < 0L || l2 > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("tcpNotSentLowAt must be a uint32_t");
        }
        LinuxSocket.setTcpNotSentLowAt(this.intValue(), (int)l2);
    }

    void setTcpFastOpen(int n2) {
        LinuxSocket.setTcpFastOpen(this.intValue(), n2);
    }

    void setTcpFastOpenConnect(boolean bl2) {
        LinuxSocket.setTcpFastOpenConnect(this.intValue(), bl2 ? 1 : 0);
    }

    boolean isTcpFastOpenConnect() {
        return LinuxSocket.isTcpFastOpenConnect(this.intValue()) != 0;
    }

    void setTcpKeepIdle(int n2) {
        LinuxSocket.setTcpKeepIdle(this.intValue(), n2);
    }

    void setTcpKeepIntvl(int n2) {
        LinuxSocket.setTcpKeepIntvl(this.intValue(), n2);
    }

    void setTcpKeepCnt(int n2) {
        LinuxSocket.setTcpKeepCnt(this.intValue(), n2);
    }

    void setTcpUserTimeout(int n2) {
        LinuxSocket.setTcpUserTimeout(this.intValue(), n2);
    }

    void setIpFreeBind(boolean bl2) {
        LinuxSocket.setIpFreeBind(this.intValue(), bl2 ? 1 : 0);
    }

    void setIpTransparent(boolean bl2) {
        LinuxSocket.setIpTransparent(this.intValue(), bl2 ? 1 : 0);
    }

    void setIpRecvOrigDestAddr(boolean bl2) {
        LinuxSocket.setIpRecvOrigDestAddr(this.intValue(), bl2 ? 1 : 0);
    }

    void getTcpInfo(EpollTcpInfo epollTcpInfo) {
        LinuxSocket.getTcpInfo(this.intValue(), epollTcpInfo.info);
    }

    void setTcpMd5Sig(InetAddress inetAddress, byte[] byArray) {
        NativeInetAddress nativeInetAddress = NativeInetAddress.newInstance(inetAddress);
        LinuxSocket.setTcpMd5Sig(this.intValue(), nativeInetAddress.address(), nativeInetAddress.scopeId(), byArray);
    }

    boolean isTcpCork() {
        return LinuxSocket.isTcpCork(this.intValue()) != 0;
    }

    int getTcpDeferAccept() {
        return LinuxSocket.getTcpDeferAccept(this.intValue());
    }

    boolean isTcpQuickAck() {
        return LinuxSocket.isTcpQuickAck(this.intValue()) != 0;
    }

    long getTcpNotSentLowAt() {
        return (long)LinuxSocket.getTcpNotSentLowAt(this.intValue()) & 0xFFFFFFFFL;
    }

    int getTcpKeepIdle() {
        return LinuxSocket.getTcpKeepIdle(this.intValue());
    }

    int getTcpKeepIntvl() {
        return LinuxSocket.getTcpKeepIntvl(this.intValue());
    }

    int getTcpKeepCnt() {
        return LinuxSocket.getTcpKeepCnt(this.intValue());
    }

    int getTcpUserTimeout() {
        return LinuxSocket.getTcpUserTimeout(this.intValue());
    }

    boolean isIpFreeBind() {
        return LinuxSocket.isIpFreeBind(this.intValue()) != 0;
    }

    boolean isIpTransparent() {
        return LinuxSocket.isIpTransparent(this.intValue()) != 0;
    }

    boolean isIpRecvOrigDestAddr() {
        return LinuxSocket.isIpRecvOrigDestAddr(this.intValue()) != 0;
    }

    PeerCredentials getPeerCredentials() {
        return LinuxSocket.getPeerCredentials(this.intValue());
    }

    long sendFile(DefaultFileRegion defaultFileRegion, long l2, long l3, long l4) {
        defaultFileRegion.open();
        long l5 = LinuxSocket.sendFile(this.intValue(), defaultFileRegion, l2, l3, l4);
        if (l5 >= 0L) {
            return l5;
        }
        return Errors.ioResult("sendfile", (int)l5, SENDFILE_CONNECTION_RESET_EXCEPTION, SENDFILE_CLOSED_CHANNEL_EXCEPTION);
    }

    public static LinuxSocket newSocketStream() {
        return new LinuxSocket(LinuxSocket.newSocketStream0());
    }

    public static LinuxSocket newSocketDgram() {
        return new LinuxSocket(LinuxSocket.newSocketDgram0());
    }

    public static LinuxSocket newSocketDomain() {
        return new LinuxSocket(LinuxSocket.newSocketDomain0());
    }

    private static native long sendFile(int var0, DefaultFileRegion var1, long var2, long var4, long var6);

    private static native int getTcpDeferAccept(int var0);

    private static native int isTcpQuickAck(int var0);

    private static native int isTcpCork(int var0);

    private static native int getTcpNotSentLowAt(int var0);

    private static native int getTcpKeepIdle(int var0);

    private static native int getTcpKeepIntvl(int var0);

    private static native int getTcpKeepCnt(int var0);

    private static native int getTcpUserTimeout(int var0);

    private static native int isIpFreeBind(int var0);

    private static native int isIpTransparent(int var0);

    private static native int isIpRecvOrigDestAddr(int var0);

    private static native void getTcpInfo(int var0, long[] var1);

    private static native PeerCredentials getPeerCredentials(int var0);

    private static native int isTcpFastOpenConnect(int var0);

    private static native void setTcpDeferAccept(int var0, int var1);

    private static native void setTcpQuickAck(int var0, int var1);

    private static native void setTcpCork(int var0, int var1);

    private static native void setTcpNotSentLowAt(int var0, int var1);

    private static native void setTcpFastOpen(int var0, int var1);

    private static native void setTcpFastOpenConnect(int var0, int var1);

    private static native void setTcpKeepIdle(int var0, int var1);

    private static native void setTcpKeepIntvl(int var0, int var1);

    private static native void setTcpKeepCnt(int var0, int var1);

    private static native void setTcpUserTimeout(int var0, int var1);

    private static native void setIpFreeBind(int var0, int var1);

    private static native void setIpTransparent(int var0, int var1);

    private static native void setIpRecvOrigDestAddr(int var0, int var1);

    private static native void setTcpMd5Sig(int var0, byte[] var1, int var2, byte[] var3);
}

