/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventArray;
import io.netty.channel.epoll.EpollEventLoop$1;
import io.netty.channel.epoll.EpollEventLoop$2;
import io.netty.channel.epoll.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.RejectedExecutionHandler;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private static final AtomicIntegerFieldUpdater<EpollEventLoop> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(EpollEventLoop.class, "wakenUp");
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap<AbstractEpollChannel>(4096);
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private final IovArray iovArray = new IovArray();
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new EpollEventLoop$1(this);
    private final Callable<Integer> pendingTasksCallable = new EpollEventLoop$2(this);
    private volatile int wakenUp;
    private volatile int ioRatio = 50;
    static final long MAX_SCHEDULED_DAYS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpollEventLoop(EventLoopGroup eventLoopGroup, Executor executor, int n2, SelectStrategy selectStrategy, RejectedExecutionHandler rejectedExecutionHandler) {
        super(eventLoopGroup, executor, false, DEFAULT_MAX_PENDING_TASKS, rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "strategy");
        if (n2 == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(n2);
        }
        boolean bl2 = false;
        FileDescriptor fileDescriptor = null;
        FileDescriptor fileDescriptor2 = null;
        FileDescriptor fileDescriptor3 = null;
        try {
            this.epollFd = fileDescriptor = Native.newEpollCreate();
            this.eventFd = fileDescriptor2 = Native.newEventFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor2.intValue(), Native.EPOLLIN);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", iOException);
            }
            this.timerFd = fileDescriptor3 = Native.newTimerFd();
            try {
                Native.epollCtlAdd(fileDescriptor.intValue(), fileDescriptor3.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", iOException);
            }
            bl2 = true;
        }
        finally {
            if (!bl2) {
                if (fileDescriptor != null) {
                    try {
                        fileDescriptor.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileDescriptor2 != null) {
                    try {
                        fileDescriptor2.close();
                    }
                    catch (Exception exception) {}
                }
                if (fileDescriptor3 != null) {
                    try {
                        fileDescriptor3.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    @Override
    protected void wakeup(boolean bl2) {
        if (!bl2 && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    void add(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        int n2 = abstractEpollChannel.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), n2, abstractEpollChannel.flags);
        this.channels.put(n2, abstractEpollChannel);
    }

    void modify(AbstractEpollChannel abstractEpollChannel) {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), abstractEpollChannel.socket.intValue(), abstractEpollChannel.flags);
    }

    void remove(AbstractEpollChannel abstractEpollChannel) {
        int n2;
        assert (this.inEventLoop());
        if (abstractEpollChannel.isOpen() && this.channels.remove(n2 = abstractEpollChannel.socket.intValue()) != null) {
            Native.epollCtlDel(this.epollFd.intValue(), abstractEpollChannel.fd().intValue());
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int n2) {
        return n2 == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(n2);
    }

    @Override
    public int pendingTasks() {
        if (this.inEventLoop()) {
            return super.pendingTasks();
        }
        return (Integer)this.submit(this.pendingTasksCallable).syncUninterruptibly().getNow();
    }

    public int getIoRatio() {
        return this.ioRatio;
    }

    public void setIoRatio(int n2) {
        if (n2 <= 0 || n2 > 100) {
            throw new IllegalArgumentException("ioRatio: " + n2 + " (expected: 0 < ioRatio <= 100)");
        }
        this.ioRatio = n2;
    }

    private int epollWait(boolean bl2) {
        if (bl2 && this.hasTasks()) {
            return this.epollWaitNow();
        }
        long l2 = this.delayNanos(System.nanoTime());
        int n2 = (int)Math.min(l2 / 1000000000L, Integer.MAX_VALUE);
        return Native.epollWait(this.epollFd, this.events, this.timerFd, n2, (int)Math.min(l2 - (long)n2 * 1000000000L, Integer.MAX_VALUE));
    }

    private int epollWaitNow() {
        return Native.epollWait(this.epollFd, this.events, this.timerFd, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void run() {
        while (true) {
            try {
                block15: while (true) {
                    var1_1 = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (var1_1) {
                        case -2: {
                            continue block15;
                        }
                        case -1: {
                            var1_1 = this.epollWait(EpollEventLoop.WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                            if (this.wakenUp != 1) break block15;
                            Native.eventFdWrite(this.eventFd.intValue(), 1L);
                        }
                    }
                    break;
                }
                var2_4 = this.ioRatio;
                if (var2_4 == 100) {
                    try {
                        if (var1_1 <= 0) ** GOTO lbl32
                        this.processReady(this.events, var1_1);
                    }
                    finally {
                        this.runAllTasks();
                    }
                } else {
                    var3_5 = System.nanoTime();
                    try {
                        if (var1_1 > 0) {
                            this.processReady(this.events, var1_1);
                        }
                    }
                    finally {
                        var5_7 = System.nanoTime() - var3_5;
                        this.runAllTasks(var5_7 * (long)(100 - var2_4) / (long)var2_4);
                    }
                }
                if (this.allowGrowing && var1_1 == this.events.length()) {
                    this.events.increase();
                }
            }
            catch (Throwable var1_2) {
                EpollEventLoop.handleLoopException(var1_2);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
            }
            catch (Throwable var1_3) {
                EpollEventLoop.handleLoopException(var1_3);
                continue;
            }
            break;
        }
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void closeAll() {
        try {
            this.epollWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ArrayList<AbstractEpollChannel> arrayList = new ArrayList<AbstractEpollChannel>(this.channels.size());
        for (AbstractEpollChannel abstractEpollChannel : this.channels.values()) {
            arrayList.add(abstractEpollChannel);
        }
        for (AbstractEpollChannel abstractEpollChannel : arrayList) {
            abstractEpollChannel.unsafe().close(abstractEpollChannel.unsafe().voidPromise());
        }
    }

    private void processReady(EpollEventArray epollEventArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = epollEventArray.fd(i2);
            if (n3 == this.eventFd.intValue()) {
                Native.eventFdRead(n3);
                continue;
            }
            if (n3 == this.timerFd.intValue()) {
                Native.timerFdRead(n3);
                continue;
            }
            long l2 = epollEventArray.events(i2);
            AbstractEpollChannel abstractEpollChannel = this.channels.get(n3);
            if (abstractEpollChannel != null) {
                AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)abstractEpollChannel.unsafe();
                if ((l2 & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    abstractEpollChannel$AbstractEpollUnsafe.epollOutReady();
                }
                if ((l2 & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    abstractEpollChannel$AbstractEpollUnsafe.epollInReady();
                }
                if ((l2 & (long)Native.EPOLLRDHUP) == 0L) continue;
                abstractEpollChannel$AbstractEpollUnsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), n3);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void cleanup() {
        try {
            try {
                this.epollFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the epoll fd.", iOException);
            }
            try {
                this.eventFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the event fd.", iOException);
            }
            try {
                this.timerFd.close();
            }
            catch (IOException iOException) {
                logger.warn("Failed to close the timer fd.", iOException);
            }
        }
        finally {
            this.iovArray.release();
            this.events.free();
        }
    }

    @Override
    protected void validateScheduled(long l2, TimeUnit timeUnit) {
        long l3 = timeUnit.toDays(l2);
        if (l3 > MAX_SCHEDULED_DAYS) {
            throw new IllegalArgumentException("days: " + l3 + " (expected: < " + MAX_SCHEDULED_DAYS + ')');
        }
    }

    static /* synthetic */ int access$000(EpollEventLoop epollEventLoop) {
        return epollEventLoop.epollWaitNow();
    }

    static /* synthetic */ int access$101(EpollEventLoop epollEventLoop) {
        return super.pendingTasks();
    }

    static {
        Epoll.ensureAvailability();
        MAX_SCHEDULED_DAYS = TimeUnit.SECONDS.toDays(999999999L);
    }
}

