/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDatagramChannelConfig;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.unix.DatagramSocketAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;

final class EpollDatagramChannel$EpollDatagramChannelUnsafe
extends AbstractEpollChannel$AbstractEpollUnsafe {
    static final /* synthetic */ boolean $assertionsDisabled;
    final /* synthetic */ EpollDatagramChannel this$0;

    EpollDatagramChannel$EpollDatagramChannelUnsafe(EpollDatagramChannel epollDatagramChannel) {
        this.this$0 = epollDatagramChannel;
        super(epollDatagramChannel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void epollInReady() {
        if (!$assertionsDisabled && !this.this$0.eventLoop().inEventLoop()) {
            throw new AssertionError();
        }
        EpollDatagramChannelConfig epollDatagramChannelConfig = this.this$0.config();
        if (this.this$0.shouldBreakEpollInReady(epollDatagramChannelConfig)) {
            this.clearEpollIn0();
            return;
        }
        EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
        epollRecvByteAllocatorHandle.edgeTriggered(this.this$0.isFlagSet(Native.EPOLLET));
        ChannelPipeline channelPipeline = this.this$0.pipeline();
        ByteBufAllocator byteBufAllocator = epollDatagramChannelConfig.getAllocator();
        epollRecvByteAllocatorHandle.reset(epollDatagramChannelConfig);
        this.epollInBefore();
        Throwable throwable = null;
        try {
            ByteBuf byteBuf = null;
            try {
                do {
                    Object object;
                    DatagramSocketAddress datagramSocketAddress;
                    byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                    epollRecvByteAllocatorHandle.attemptedBytesRead(byteBuf.writableBytes());
                    if (byteBuf.hasMemoryAddress()) {
                        datagramSocketAddress = this.this$0.socket.recvFromAddress(byteBuf.memoryAddress(), byteBuf.writerIndex(), byteBuf.capacity());
                    } else {
                        object = byteBuf.internalNioBuffer(byteBuf.writerIndex(), byteBuf.writableBytes());
                        datagramSocketAddress = this.this$0.socket.recvFrom((ByteBuffer)object, ((Buffer)object).position(), ((Buffer)object).limit());
                    }
                    if (datagramSocketAddress == null) {
                        epollRecvByteAllocatorHandle.lastBytesRead(-1);
                        byteBuf.release();
                        byteBuf = null;
                        break;
                    }
                    object = datagramSocketAddress.localAddress();
                    if (object == null) {
                        object = (InetSocketAddress)this.localAddress();
                    }
                    epollRecvByteAllocatorHandle.incMessagesRead(1);
                    epollRecvByteAllocatorHandle.lastBytesRead(datagramSocketAddress.receivedAmount());
                    byteBuf.writerIndex(byteBuf.writerIndex() + epollRecvByteAllocatorHandle.lastBytesRead());
                    this.readPending = false;
                    channelPipeline.fireChannelRead(new DatagramPacket(byteBuf, (InetSocketAddress)object, datagramSocketAddress));
                    byteBuf = null;
                } while (epollRecvByteAllocatorHandle.continueReading());
            }
            catch (Throwable throwable2) {
                if (byteBuf != null) {
                    byteBuf.release();
                }
                throwable = throwable2;
            }
            epollRecvByteAllocatorHandle.readComplete();
            channelPipeline.fireChannelReadComplete();
            if (throwable != null) {
                channelPipeline.fireExceptionCaught(throwable);
            }
        }
        finally {
            this.epollInFinally(epollDatagramChannelConfig);
        }
    }

    static {
        $assertionsDisabled = !EpollDatagramChannel.class.desiredAssertionStatus();
    }
}

