/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.RecvByteBufAllocator$ExtendedHandle;
import io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.netty.channel.epoll.AbstractEpollStreamChannel;
import io.netty.channel.epoll.AbstractEpollStreamChannel$SpliceInTask;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollRecvByteAllocatorHandle;
import io.netty.channel.epoll.EpollRecvByteAllocatorStreamingHandle;
import io.netty.channel.epoll.Native;
import java.io.IOException;
import java.util.concurrent.Executor;

class AbstractEpollStreamChannel$EpollStreamUnsafe
extends AbstractEpollChannel$AbstractEpollUnsafe {
    final /* synthetic */ AbstractEpollStreamChannel this$0;

    AbstractEpollStreamChannel$EpollStreamUnsafe(AbstractEpollStreamChannel abstractEpollStreamChannel) {
        this.this$0 = abstractEpollStreamChannel;
        super(abstractEpollStreamChannel);
    }

    @Override
    protected Executor prepareToClose() {
        return super.prepareToClose();
    }

    private void handleReadException(ChannelPipeline channelPipeline, ByteBuf byteBuf, Throwable throwable, boolean bl2, EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle) {
        if (byteBuf != null) {
            if (byteBuf.isReadable()) {
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
            } else {
                byteBuf.release();
            }
        }
        epollRecvByteAllocatorHandle.readComplete();
        channelPipeline.fireChannelReadComplete();
        channelPipeline.fireExceptionCaught(throwable);
        if (bl2 || throwable instanceof IOException) {
            this.shutdownInput(false);
        }
    }

    @Override
    EpollRecvByteAllocatorHandle newEpollHandle(RecvByteBufAllocator$ExtendedHandle recvByteBufAllocator$ExtendedHandle) {
        return new EpollRecvByteAllocatorStreamingHandle(recvByteBufAllocator$ExtendedHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void epollInReady() {
        EpollChannelConfig epollChannelConfig = this.this$0.config();
        if (this.this$0.shouldBreakEpollInReady(epollChannelConfig)) {
            this.clearEpollIn0();
            return;
        }
        EpollRecvByteAllocatorHandle epollRecvByteAllocatorHandle = this.recvBufAllocHandle();
        epollRecvByteAllocatorHandle.edgeTriggered(this.this$0.isFlagSet(Native.EPOLLET));
        ChannelPipeline channelPipeline = this.this$0.pipeline();
        ByteBufAllocator byteBufAllocator = epollChannelConfig.getAllocator();
        epollRecvByteAllocatorHandle.reset(epollChannelConfig);
        this.epollInBefore();
        ByteBuf byteBuf = null;
        boolean bl2 = false;
        try {
            do {
                AbstractEpollStreamChannel$SpliceInTask abstractEpollStreamChannel$SpliceInTask;
                if (AbstractEpollStreamChannel.access$400(this.this$0) != null && (abstractEpollStreamChannel$SpliceInTask = (AbstractEpollStreamChannel$SpliceInTask)AbstractEpollStreamChannel.access$400(this.this$0).peek()) != null) {
                    if (!abstractEpollStreamChannel$SpliceInTask.spliceIn(epollRecvByteAllocatorHandle)) break;
                    if (!this.this$0.isActive()) continue;
                    AbstractEpollStreamChannel.access$400(this.this$0).remove();
                    continue;
                }
                byteBuf = epollRecvByteAllocatorHandle.allocate(byteBufAllocator);
                epollRecvByteAllocatorHandle.lastBytesRead(this.this$0.doReadBytes(byteBuf));
                if (epollRecvByteAllocatorHandle.lastBytesRead() <= 0) {
                    byteBuf.release();
                    byteBuf = null;
                    boolean bl3 = bl2 = epollRecvByteAllocatorHandle.lastBytesRead() < 0;
                    if (!bl2) break;
                    this.readPending = false;
                    break;
                }
                epollRecvByteAllocatorHandle.incMessagesRead(1);
                this.readPending = false;
                channelPipeline.fireChannelRead(byteBuf);
                byteBuf = null;
                if (this.this$0.shouldBreakEpollInReady(epollChannelConfig)) break;
            } while (epollRecvByteAllocatorHandle.continueReading());
            epollRecvByteAllocatorHandle.readComplete();
            channelPipeline.fireChannelReadComplete();
            if (bl2) {
                this.shutdownInput(false);
            }
        }
        catch (Throwable throwable) {
            this.handleReadException(channelPipeline, byteBuf, throwable, bl2, epollRecvByteAllocatorHandle);
        }
        finally {
            this.epollInFinally(epollChannelConfig);
        }
    }
}

