/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.epoll.AbstractEpollChannel$1;
import io.netty.channel.epoll.AbstractEpollChannel$2;
import io.netty.channel.epoll.AbstractEpollChannel$AbstractEpollUnsafe;
import io.netty.channel.epoll.EpollChannelConfig;
import io.netty.channel.epoll.EpollEventLoop;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.epoll.Native;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.Socket;
import io.netty.channel.unix.UnixChannel;
import io.netty.channel.unix.UnixChannelUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.ThrowableUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.UnresolvedAddressException;
import java.util.concurrent.ScheduledFuture;

abstract class AbstractEpollChannel
extends AbstractChannel
implements UnixChannel {
    private static final ClosedChannelException DO_CLOSE_CLOSED_CHANNEL_EXCEPTION = ThrowableUtil.unknownStackTrace(new ClosedChannelException(), AbstractEpollChannel.class, "doClose()");
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final int readFlag;
    final LinuxSocket socket;
    private ChannelPromise connectPromise;
    private ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;
    private volatile SocketAddress local;
    private volatile SocketAddress remote;
    protected int flags = Native.EPOLLET;
    boolean inputClosedSeenErrorOnRead;
    boolean epollInReadyRunnablePending;
    protected volatile boolean active;

    AbstractEpollChannel(LinuxSocket linuxSocket, int n2) {
        this(null, linuxSocket, n2, false);
    }

    AbstractEpollChannel(Channel channel, LinuxSocket linuxSocket, int n2, boolean bl2) {
        super(channel);
        this.socket = ObjectUtil.checkNotNull(linuxSocket, "fd");
        this.readFlag = n2;
        this.flags |= n2;
        this.active = bl2;
        if (bl2) {
            this.local = linuxSocket.localAddress();
            this.remote = linuxSocket.remoteAddress();
        }
    }

    AbstractEpollChannel(Channel channel, LinuxSocket linuxSocket, int n2, SocketAddress socketAddress) {
        super(channel);
        this.socket = ObjectUtil.checkNotNull(linuxSocket, "fd");
        this.readFlag = n2;
        this.flags |= n2;
        this.active = true;
        this.remote = socketAddress;
        this.local = linuxSocket.localAddress();
    }

    static boolean isSoErrorZero(Socket socket) {
        try {
            return socket.getSoError() == 0;
        }
        catch (IOException iOException) {
            throw new ChannelException(iOException);
        }
    }

    void setFlag(int n2) {
        if (!this.isFlagSet(n2)) {
            this.flags |= n2;
            this.modifyEvents();
        }
    }

    void clearFlag(int n2) {
        if (this.isFlagSet(n2)) {
            this.flags &= ~n2;
            this.modifyEvents();
        }
    }

    boolean isFlagSet(int n2) {
        return (this.flags & n2) != 0;
    }

    @Override
    public final FileDescriptor fd() {
        return this.socket;
    }

    @Override
    public abstract EpollChannelConfig config();

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        this.active = false;
        this.inputClosedSeenErrorOnRead = true;
        try {
            ScheduledFuture<?> scheduledFuture;
            ChannelPromise channelPromise = this.connectPromise;
            if (channelPromise != null) {
                channelPromise.tryFailure(DO_CLOSE_CLOSED_CHANNEL_EXCEPTION);
                this.connectPromise = null;
            }
            if ((scheduledFuture = this.connectTimeoutFuture) != null) {
                scheduledFuture.cancel(false);
                this.connectTimeoutFuture = null;
            }
            if (this.isRegistered()) {
                EventLoop eventLoop = this.eventLoop();
                if (eventLoop.inEventLoop()) {
                    this.doDeregister();
                } else {
                    eventLoop.execute(new AbstractEpollChannel$1(this));
                }
            }
        }
        finally {
            this.socket.close();
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EpollEventLoop;
    }

    @Override
    public boolean isOpen() {
        return this.socket.isOpen();
    }

    @Override
    protected void doDeregister() {
        ((EpollEventLoop)this.eventLoop()).remove(this);
    }

    @Override
    protected final void doBeginRead() {
        AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)this.unsafe();
        abstractEpollChannel$AbstractEpollUnsafe.readPending = true;
        this.setFlag(this.readFlag);
        if (abstractEpollChannel$AbstractEpollUnsafe.maybeMoreDataToRead) {
            abstractEpollChannel$AbstractEpollUnsafe.executeEpollInReadyRunnable(this.config());
        }
    }

    final boolean shouldBreakEpollInReady(ChannelConfig channelConfig) {
        return this.socket.isInputShutdown() && (this.inputClosedSeenErrorOnRead || !AbstractEpollChannel.isAllowHalfClosure(channelConfig));
    }

    private static boolean isAllowHalfClosure(ChannelConfig channelConfig) {
        return channelConfig instanceof SocketChannelConfig && ((SocketChannelConfig)channelConfig).isAllowHalfClosure();
    }

    final void clearEpollIn() {
        if (this.isRegistered()) {
            EventLoop eventLoop = this.eventLoop();
            AbstractEpollChannel$AbstractEpollUnsafe abstractEpollChannel$AbstractEpollUnsafe = (AbstractEpollChannel$AbstractEpollUnsafe)this.unsafe();
            if (eventLoop.inEventLoop()) {
                abstractEpollChannel$AbstractEpollUnsafe.clearEpollIn0();
            } else {
                eventLoop.execute(new AbstractEpollChannel$2(this, abstractEpollChannel$AbstractEpollUnsafe));
            }
        } else {
            this.flags &= ~this.readFlag;
        }
    }

    private void modifyEvents() {
        if (this.isOpen() && this.isRegistered()) {
            ((EpollEventLoop)this.eventLoop()).modify(this);
        }
    }

    @Override
    protected void doRegister() {
        this.epollInReadyRunnablePending = false;
        ((EpollEventLoop)this.eventLoop()).add(this);
    }

    @Override
    protected abstract AbstractEpollChannel$AbstractEpollUnsafe newUnsafe();

    protected final ByteBuf newDirectBuffer(ByteBuf byteBuf) {
        return this.newDirectBuffer(byteBuf, byteBuf);
    }

    protected final ByteBuf newDirectBuffer(Object object, ByteBuf byteBuf) {
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            ReferenceCountUtil.release(object);
            return Unpooled.EMPTY_BUFFER;
        }
        ByteBufAllocator byteBufAllocator = this.alloc();
        if (byteBufAllocator.isDirectBufferPooled()) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n2);
        }
        ByteBuf byteBuf2 = ByteBufUtil.threadLocalDirectBuffer();
        if (byteBuf2 == null) {
            return AbstractEpollChannel.newDirectBuffer0(object, byteBuf, byteBufAllocator, n2);
        }
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    private static ByteBuf newDirectBuffer0(Object object, ByteBuf byteBuf, ByteBufAllocator byteBufAllocator, int n2) {
        ByteBuf byteBuf2 = byteBufAllocator.directBuffer(n2);
        byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), n2);
        ReferenceCountUtil.safeRelease(object);
        return byteBuf2;
    }

    protected static void checkResolvable(InetSocketAddress inetSocketAddress) {
        if (inetSocketAddress.isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    protected final int doReadBytes(ByteBuf byteBuf) {
        int n2;
        int n3 = byteBuf.writerIndex();
        this.unsafe().recvBufAllocHandle().attemptedBytesRead(byteBuf.writableBytes());
        if (byteBuf.hasMemoryAddress()) {
            n2 = this.socket.readAddress(byteBuf.memoryAddress(), n3, byteBuf.capacity());
        } else {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(n3, byteBuf.writableBytes());
            n2 = this.socket.read(byteBuffer, byteBuffer.position(), byteBuffer.limit());
        }
        if (n2 > 0) {
            byteBuf.writerIndex(n3 + n2);
        }
        return n2;
    }

    protected final int doWriteBytes(ChannelOutboundBuffer channelOutboundBuffer, ByteBuf byteBuf) {
        if (byteBuf.hasMemoryAddress()) {
            int n2 = this.socket.writeAddress(byteBuf.memoryAddress(), byteBuf.readerIndex(), byteBuf.writerIndex());
            if (n2 > 0) {
                channelOutboundBuffer.removeBytes(n2);
                return 1;
            }
        } else {
            ByteBuffer byteBuffer = byteBuf.nioBufferCount() == 1 ? byteBuf.internalNioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()) : byteBuf.nioBuffer();
            int n3 = this.socket.write(byteBuffer, byteBuffer.position(), byteBuffer.limit());
            if (n3 > 0) {
                byteBuffer.position(byteBuffer.position() + n3);
                channelOutboundBuffer.removeBytes(n3);
                return 1;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)socketAddress);
        }
        this.socket.bind(socketAddress);
        this.local = this.socket.localAddress();
    }

    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        boolean bl2;
        InetSocketAddress inetSocketAddress;
        if (socketAddress2 instanceof InetSocketAddress) {
            AbstractEpollChannel.checkResolvable((InetSocketAddress)socketAddress2);
        }
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        if (inetSocketAddress != null) {
            AbstractEpollChannel.checkResolvable(inetSocketAddress);
        }
        if (this.remote != null) {
            throw new AlreadyConnectedException();
        }
        if (socketAddress2 != null) {
            this.socket.bind(socketAddress2);
        }
        if (bl2 = this.doConnect0(socketAddress)) {
            this.remote = inetSocketAddress == null ? socketAddress : UnixChannelUtil.computeRemoteAddr(inetSocketAddress, this.socket.remoteAddress());
        }
        this.local = this.socket.localAddress();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doConnect0(SocketAddress socketAddress) {
        boolean bl2 = false;
        try {
            boolean bl3 = this.socket.connect(socketAddress);
            if (!bl3) {
                this.setFlag(Native.EPOLLOUT);
            }
            bl2 = true;
            boolean bl4 = bl3;
            return bl4;
        }
        finally {
            if (!bl2) {
                this.doClose();
            }
        }
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.local;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.remote;
    }

    static /* synthetic */ boolean access$000(ChannelConfig channelConfig) {
        return AbstractEpollChannel.isAllowHalfClosure(channelConfig);
    }

    static /* synthetic */ ChannelPromise access$100(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.connectPromise;
    }

    static /* synthetic */ int access$200(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.readFlag;
    }

    static /* synthetic */ ChannelPromise access$102(AbstractEpollChannel abstractEpollChannel, ChannelPromise channelPromise) {
        abstractEpollChannel.connectPromise = channelPromise;
        return abstractEpollChannel.connectPromise;
    }

    static /* synthetic */ SocketAddress access$302(AbstractEpollChannel abstractEpollChannel, SocketAddress socketAddress) {
        abstractEpollChannel.requestedRemoteAddress = socketAddress;
        return abstractEpollChannel.requestedRemoteAddress;
    }

    static /* synthetic */ ScheduledFuture access$402(AbstractEpollChannel abstractEpollChannel, ScheduledFuture scheduledFuture) {
        abstractEpollChannel.connectTimeoutFuture = scheduledFuture;
        return abstractEpollChannel.connectTimeoutFuture;
    }

    static /* synthetic */ ScheduledFuture access$400(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.connectTimeoutFuture;
    }

    static /* synthetic */ SocketAddress access$300(AbstractEpollChannel abstractEpollChannel) {
        return abstractEpollChannel.requestedRemoteAddress;
    }

    static /* synthetic */ SocketAddress access$502(AbstractEpollChannel abstractEpollChannel, SocketAddress socketAddress) {
        abstractEpollChannel.remote = socketAddress;
        return abstractEpollChannel.remote;
    }
}

