/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

public final class WriteBufferWaterMark {
    private static final int DEFAULT_LOW_WATER_MARK = 32768;
    private static final int DEFAULT_HIGH_WATER_MARK = 65536;
    public static final WriteBufferWaterMark DEFAULT = new WriteBufferWaterMark(32768, 65536, false);
    private final int low;
    private final int high;

    public WriteBufferWaterMark(int n2, int n3) {
        this(n2, n3, true);
    }

    WriteBufferWaterMark(int n2, int n3, boolean bl2) {
        if (bl2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("write buffer's low water mark must be >= 0");
            }
            if (n3 < n2) {
                throw new IllegalArgumentException("write buffer's high water mark cannot be less than  low water mark (" + n2 + "): " + n3);
            }
        }
        this.low = n2;
        this.high = n3;
    }

    public int low() {
        return this.low;
    }

    public int high() {
        return this.high;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(55).append("WriteBufferWaterMark(low: ").append(this.low).append(", high: ").append(this.high).append(")");
        return stringBuilder.toString();
    }
}

