/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.internal.ObjectUtil;

public final class PreferHeapByteBufAllocator
implements ByteBufAllocator {
    private final ByteBufAllocator allocator;

    public PreferHeapByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.allocator = ObjectUtil.checkNotNull(byteBufAllocator, "allocator");
    }

    @Override
    public ByteBuf buffer() {
        return this.allocator.heapBuffer();
    }

    @Override
    public ByteBuf buffer(int n2) {
        return this.allocator.heapBuffer(n2);
    }

    @Override
    public ByteBuf buffer(int n2, int n3) {
        return this.allocator.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf ioBuffer() {
        return this.allocator.heapBuffer();
    }

    @Override
    public ByteBuf ioBuffer(int n2) {
        return this.allocator.heapBuffer(n2);
    }

    @Override
    public ByteBuf ioBuffer(int n2, int n3) {
        return this.allocator.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.allocator.heapBuffer();
    }

    @Override
    public ByteBuf heapBuffer(int n2) {
        return this.allocator.heapBuffer(n2);
    }

    @Override
    public ByteBuf heapBuffer(int n2, int n3) {
        return this.allocator.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf directBuffer() {
        return this.allocator.directBuffer();
    }

    @Override
    public ByteBuf directBuffer(int n2) {
        return this.allocator.directBuffer(n2);
    }

    @Override
    public ByteBuf directBuffer(int n2, int n3) {
        return this.allocator.directBuffer(n2, n3);
    }

    @Override
    public CompositeByteBuf compositeBuffer() {
        return this.allocator.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeBuffer(int n2) {
        return this.allocator.compositeHeapBuffer(n2);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer() {
        return this.allocator.compositeHeapBuffer();
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n2) {
        return this.allocator.compositeHeapBuffer(n2);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer() {
        return this.allocator.compositeDirectBuffer();
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n2) {
        return this.allocator.compositeDirectBuffer(n2);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return this.allocator.isDirectBufferPooled();
    }

    @Override
    public int calculateNewCapacity(int n2, int n3) {
        return this.allocator.calculateNewCapacity(n2, n3);
    }
}

