/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.MessageSizeEstimator$Handle;
import io.netty.channel.PendingBytesTracker$ChannelOutboundBufferPendingBytesTracker;
import io.netty.channel.PendingBytesTracker$DefaultChannelPipelinePendingBytesTracker;
import io.netty.channel.PendingBytesTracker$NoopPendingBytesTracker;
import io.netty.util.internal.ObjectUtil;

abstract class PendingBytesTracker
implements MessageSizeEstimator$Handle {
    private final MessageSizeEstimator$Handle estimatorHandle;

    private PendingBytesTracker(MessageSizeEstimator$Handle messageSizeEstimator$Handle) {
        this.estimatorHandle = ObjectUtil.checkNotNull(messageSizeEstimator$Handle, "estimatorHandle");
    }

    @Override
    public final int size(Object object) {
        return this.estimatorHandle.size(object);
    }

    public abstract void incrementPendingOutboundBytes(long var1);

    public abstract void decrementPendingOutboundBytes(long var1);

    static PendingBytesTracker newTracker(Channel channel) {
        if (channel.pipeline() instanceof DefaultChannelPipeline) {
            return new PendingBytesTracker$DefaultChannelPipelinePendingBytesTracker((DefaultChannelPipeline)channel.pipeline());
        }
        ChannelOutboundBuffer channelOutboundBuffer = channel.unsafe().outboundBuffer();
        MessageSizeEstimator$Handle messageSizeEstimator$Handle = channel.config().getMessageSizeEstimator().newHandle();
        return channelOutboundBuffer == null ? new PendingBytesTracker$NoopPendingBytesTracker(messageSizeEstimator$Handle) : new PendingBytesTracker$ChannelOutboundBufferPendingBytesTracker(channelOutboundBuffer, messageSizeEstimator$Handle);
    }
}

