/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultMaxBytesRecvByteBufAllocator$HandleImpl;
import io.netty.channel.MaxBytesRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator$Handle;
import java.util.AbstractMap;
import java.util.Map;

public class DefaultMaxBytesRecvByteBufAllocator
implements MaxBytesRecvByteBufAllocator {
    private volatile int maxBytesPerRead;
    private volatile int maxBytesPerIndividualRead;

    public DefaultMaxBytesRecvByteBufAllocator() {
        this(65536, 65536);
    }

    public DefaultMaxBytesRecvByteBufAllocator(int n2, int n3) {
        DefaultMaxBytesRecvByteBufAllocator.checkMaxBytesPerReadPair(n2, n3);
        this.maxBytesPerRead = n2;
        this.maxBytesPerIndividualRead = n3;
    }

    @Override
    public RecvByteBufAllocator$Handle newHandle() {
        return new DefaultMaxBytesRecvByteBufAllocator$HandleImpl(this, null);
    }

    @Override
    public int maxBytesPerRead() {
        return this.maxBytesPerRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerRead(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxBytesPerRead: " + n2 + " (expected: > 0)");
        }
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            int n3 = this.maxBytesPerIndividualRead();
            if (n2 < n3) {
                throw new IllegalArgumentException("maxBytesPerRead cannot be less than maxBytesPerIndividualRead (" + n3 + "): " + n2);
            }
            this.maxBytesPerRead = n2;
        }
        return this;
    }

    @Override
    public int maxBytesPerIndividualRead() {
        return this.maxBytesPerIndividualRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerIndividualRead(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxBytesPerIndividualRead: " + n2 + " (expected: > 0)");
        }
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            int n3 = this.maxBytesPerRead();
            if (n2 > n3) {
                throw new IllegalArgumentException("maxBytesPerIndividualRead cannot be greater than maxBytesPerRead (" + n3 + "): " + n2);
            }
            this.maxBytesPerIndividualRead = n2;
        }
        return this;
    }

    @Override
    public synchronized Map.Entry<Integer, Integer> maxBytesPerReadPair() {
        return new AbstractMap.SimpleEntry<Integer, Integer>(this.maxBytesPerRead, this.maxBytesPerIndividualRead);
    }

    private static void checkMaxBytesPerReadPair(int n2, int n3) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("maxBytesPerRead: " + n2 + " (expected: > 0)");
        }
        if (n3 <= 0) {
            throw new IllegalArgumentException("maxBytesPerIndividualRead: " + n3 + " (expected: > 0)");
        }
        if (n2 < n3) {
            throw new IllegalArgumentException("maxBytesPerRead cannot be less than maxBytesPerIndividualRead (" + n3 + "): " + n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultMaxBytesRecvByteBufAllocator maxBytesPerReadPair(int n2, int n3) {
        DefaultMaxBytesRecvByteBufAllocator.checkMaxBytesPerReadPair(n2, n3);
        DefaultMaxBytesRecvByteBufAllocator defaultMaxBytesRecvByteBufAllocator = this;
        synchronized (defaultMaxBytesRecvByteBufAllocator) {
            this.maxBytesPerRead = n2;
            this.maxBytesPerIndividualRead = n3;
        }
        return this;
    }
}

