/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelId;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

public final class DefaultChannelId
implements ChannelId {
    private static final long serialVersionUID = 3884076183504074063L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID_LEN = 4;
    private static final int PROCESS_ID;
    private static final int SEQUENCE_LEN = 4;
    private static final int TIMESTAMP_LEN = 8;
    private static final int RANDOM_LEN = 4;
    private static final AtomicInteger nextSequence;
    private final byte[] data = new byte[MACHINE_ID.length + 4 + 4 + 8 + 4];
    private final int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        return new DefaultChannelId();
    }

    private static int defaultProcessId() {
        int n2;
        String string;
        Class<?> clazz;
        ClassLoader classLoader = null;
        try {
            classLoader = PlatformDependent.getClassLoader(DefaultChannelId.class);
            Class<?> clazz2 = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            Method method = clazz2.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            Object object = method.invoke(null, EmptyArrays.EMPTY_OBJECTS);
            Method method2 = clazz.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            string = (String)method2.invoke(object, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Throwable throwable) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", throwable);
            try {
                clazz = Class.forName("android.os.Process", true, classLoader);
                Method method = clazz.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                string = method.invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Throwable throwable2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", throwable2);
                string = "";
            }
        }
        int n3 = string.indexOf(64);
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = -1;
        }
        if (n2 < 0) {
            n2 = PlatformDependent.threadLocalRandom().nextInt();
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", (Object)string, (Object)n2);
        }
        return n2;
    }

    private DefaultChannelId() {
        int n2 = 0;
        System.arraycopy(MACHINE_ID, 0, this.data, n2, MACHINE_ID.length);
        n2 += MACHINE_ID.length;
        n2 = this.writeInt(n2, PROCESS_ID);
        n2 = this.writeInt(n2, nextSequence.getAndIncrement());
        n2 = this.writeLong(n2, Long.reverse(System.nanoTime()) ^ System.currentTimeMillis());
        int n3 = PlatformDependent.threadLocalRandom().nextInt();
        n2 = this.writeInt(n2, n3);
        assert (n2 == this.data.length);
        this.hashCode = Arrays.hashCode(this.data);
    }

    private int writeInt(int n2, int n3) {
        this.data[n2++] = (byte)(n3 >>> 24);
        this.data[n2++] = (byte)(n3 >>> 16);
        this.data[n2++] = (byte)(n3 >>> 8);
        this.data[n2++] = (byte)n3;
        return n2;
    }

    private int writeLong(int n2, long l2) {
        this.data[n2++] = (byte)(l2 >>> 56);
        this.data[n2++] = (byte)(l2 >>> 48);
        this.data[n2++] = (byte)(l2 >>> 40);
        this.data[n2++] = (byte)(l2 >>> 32);
        this.data[n2++] = (byte)(l2 >>> 24);
        this.data[n2++] = (byte)(l2 >>> 16);
        this.data[n2++] = (byte)(l2 >>> 8);
        this.data[n2++] = (byte)l2;
        return n2;
    }

    @Override
    public String asShortText() {
        String string = this.shortValue;
        if (string == null) {
            this.shortValue = string = ByteBufUtil.hexDump(this.data, this.data.length - 4, 4);
        }
        return string;
    }

    @Override
    public String asLongText() {
        String string = this.longValue;
        if (string == null) {
            this.longValue = string = this.newLongValue();
        }
        return string;
    }

    private String newLongValue() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.data.length + 5);
        int n2 = 0;
        n2 = this.appendHexDumpField(stringBuilder, n2, MACHINE_ID.length);
        n2 = this.appendHexDumpField(stringBuilder, n2, 4);
        n2 = this.appendHexDumpField(stringBuilder, n2, 4);
        n2 = this.appendHexDumpField(stringBuilder, n2, 8);
        n2 = this.appendHexDumpField(stringBuilder, n2, 4);
        assert (n2 == this.data.length);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private int appendHexDumpField(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(ByteBufUtil.hexDump(this.data, n2, n3));
        stringBuilder.append('-');
        return n2 += n3;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ChannelId channelId) {
        if (this == channelId) {
            return 0;
        }
        if (channelId instanceof DefaultChannelId) {
            byte[] byArray = ((DefaultChannelId)channelId).data;
            int n2 = this.data.length;
            int n3 = byArray.length;
            int n4 = Math.min(n2, n3);
            for (int i2 = 0; i2 < n4; ++i2) {
                byte by2 = this.data[i2];
                byte by3 = byArray[i2];
                if (by2 == by3) continue;
                return (by2 & 0xFF) - (by3 & 0xFF);
            }
            return n2 - n3;
        }
        return this.asLongText().compareTo(channelId.asLongText());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DefaultChannelId)) {
            return false;
        }
        DefaultChannelId defaultChannelId = (DefaultChannelId)object;
        return this.hashCode == defaultChannelId.hashCode && Arrays.equals(this.data, defaultChannelId.data);
    }

    public String toString() {
        return this.asShortText();
    }

    static {
        nextSequence = new AtomicInteger();
        int n2 = -1;
        String string = SystemPropertyUtil.get("io.netty.processId");
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 < 0) {
                n2 = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)n2);
            }
        }
        if (n2 < 0) {
            n2 = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)n2);
            }
        }
        PROCESS_ID = n2;
        byte[] byArray = null;
        String string2 = SystemPropertyUtil.get("io.netty.machineId");
        if (string2 != null) {
            try {
                byArray = MacAddressUtil.parseMAC(string2);
            }
            catch (Exception exception) {
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)string2, (Object)exception);
            }
            if (byArray != null) {
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)string2);
            }
        }
        if (byArray == null) {
            byArray = MacAddressUtil.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress(byArray));
            }
        }
        MACHINE_ID = byArray;
    }
}

