/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler$1;
import io.netty.channel.CombinedChannelDuplexHandler$DelegatingChannelHandlerContext;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;

public class CombinedChannelDuplexHandler<I extends ChannelInboundHandler, O extends ChannelOutboundHandler>
extends ChannelDuplexHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CombinedChannelDuplexHandler.class);
    private CombinedChannelDuplexHandler$DelegatingChannelHandlerContext inboundCtx;
    private CombinedChannelDuplexHandler$DelegatingChannelHandlerContext outboundCtx;
    private volatile boolean handlerAdded;
    private I inboundHandler;
    private O outboundHandler;

    protected CombinedChannelDuplexHandler() {
        this.ensureNotSharable();
    }

    public CombinedChannelDuplexHandler(I i2, O o2) {
        this.ensureNotSharable();
        this.init(i2, o2);
    }

    protected final void init(I i2, O o2) {
        this.validate(i2, o2);
        this.inboundHandler = i2;
        this.outboundHandler = o2;
    }

    private void validate(I i2, O o2) {
        if (this.inboundHandler != null) {
            throw new IllegalStateException("init() can not be invoked if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with non-default constructor.");
        }
        if (i2 == null) {
            throw new NullPointerException("inboundHandler");
        }
        if (o2 == null) {
            throw new NullPointerException("outboundHandler");
        }
        if (i2 instanceof ChannelOutboundHandler) {
            throw new IllegalArgumentException("inboundHandler must not implement " + ChannelOutboundHandler.class.getSimpleName() + " to get combined.");
        }
        if (o2 instanceof ChannelInboundHandler) {
            throw new IllegalArgumentException("outboundHandler must not implement " + ChannelInboundHandler.class.getSimpleName() + " to get combined.");
        }
    }

    protected final I inboundHandler() {
        return this.inboundHandler;
    }

    protected final O outboundHandler() {
        return this.outboundHandler;
    }

    private void checkAdded() {
        if (!this.handlerAdded) {
            throw new IllegalStateException("handler not added to pipeline yet");
        }
    }

    public final void removeInboundHandler() {
        this.checkAdded();
        this.inboundCtx.remove();
    }

    public final void removeOutboundHandler() {
        this.checkAdded();
        this.outboundCtx.remove();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        if (this.inboundHandler == null) {
            throw new IllegalStateException("init() must be invoked before being added to a " + ChannelPipeline.class.getSimpleName() + " if " + CombinedChannelDuplexHandler.class.getSimpleName() + " was constructed with the default constructor.");
        }
        this.outboundCtx = new CombinedChannelDuplexHandler$DelegatingChannelHandlerContext(channelHandlerContext, (ChannelHandler)this.outboundHandler);
        this.inboundCtx = new CombinedChannelDuplexHandler$1(this, channelHandlerContext, (ChannelHandler)this.inboundHandler);
        this.handlerAdded = true;
        try {
            this.inboundHandler.handlerAdded(this.inboundCtx);
        }
        finally {
            this.outboundHandler.handlerAdded(this.outboundCtx);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            this.inboundCtx.remove();
        }
        finally {
            this.outboundCtx.remove();
        }
    }

    @Override
    public void channelRegistered(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRegistered(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelRegistered();
        }
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelUnregistered(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelUnregistered();
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelActive(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelActive();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelInactive(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelInactive();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.exceptionCaught(this.inboundCtx, throwable);
        } else {
            this.inboundCtx.fireExceptionCaught(throwable);
        }
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.userEventTriggered(this.inboundCtx, object);
        } else {
            this.inboundCtx.fireUserEventTriggered(object);
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelRead(this.inboundCtx, object);
        } else {
            this.inboundCtx.fireChannelRead(object);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelReadComplete(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelReadComplete();
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.inboundCtx));
        if (!this.inboundCtx.removed) {
            this.inboundHandler.channelWritabilityChanged(this.inboundCtx);
        } else {
            this.inboundCtx.fireChannelWritabilityChanged();
        }
    }

    @Override
    public void bind(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.bind(this.outboundCtx, socketAddress, channelPromise);
        } else {
            this.outboundCtx.bind(socketAddress, channelPromise);
        }
    }

    @Override
    public void connect(ChannelHandlerContext channelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.connect(this.outboundCtx, socketAddress, socketAddress2, channelPromise);
        } else {
            this.outboundCtx.connect(socketAddress2, channelPromise);
        }
    }

    @Override
    public void disconnect(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.disconnect(this.outboundCtx, channelPromise);
        } else {
            this.outboundCtx.disconnect(channelPromise);
        }
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.close(this.outboundCtx, channelPromise);
        } else {
            this.outboundCtx.close(channelPromise);
        }
    }

    @Override
    public void deregister(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.deregister(this.outboundCtx, channelPromise);
        } else {
            this.outboundCtx.deregister(channelPromise);
        }
    }

    @Override
    public void read(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.read(this.outboundCtx);
        } else {
            this.outboundCtx.read();
        }
    }

    @Override
    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.write(this.outboundCtx, object, channelPromise);
        } else {
            this.outboundCtx.write(object, channelPromise);
        }
    }

    @Override
    public void flush(ChannelHandlerContext channelHandlerContext) {
        assert (channelHandlerContext == CombinedChannelDuplexHandler$DelegatingChannelHandlerContext.access$300(this.outboundCtx));
        if (!this.outboundCtx.removed) {
            this.outboundHandler.flush(this.outboundCtx);
        } else {
            this.outboundCtx.flush();
        }
    }

    static /* synthetic */ CombinedChannelDuplexHandler$DelegatingChannelHandlerContext access$000(CombinedChannelDuplexHandler combinedChannelDuplexHandler) {
        return combinedChannelDuplexHandler.outboundCtx;
    }

    static /* synthetic */ ChannelOutboundHandler access$100(CombinedChannelDuplexHandler combinedChannelDuplexHandler) {
        return combinedChannelDuplexHandler.outboundHandler;
    }

    static /* synthetic */ InternalLogger access$200() {
        return logger;
    }
}

