/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler$DelegatingChannelHandlerContext$1;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import java.net.SocketAddress;

class CombinedChannelDuplexHandler$DelegatingChannelHandlerContext
implements ChannelHandlerContext {
    private final ChannelHandlerContext ctx;
    private final ChannelHandler handler;
    boolean removed;

    CombinedChannelDuplexHandler$DelegatingChannelHandlerContext(ChannelHandlerContext channelHandlerContext, ChannelHandler channelHandler) {
        this.ctx = channelHandlerContext;
        this.handler = channelHandler;
    }

    @Override
    public Channel channel() {
        return this.ctx.channel();
    }

    @Override
    public EventExecutor executor() {
        return this.ctx.executor();
    }

    @Override
    public String name() {
        return this.ctx.name();
    }

    @Override
    public ChannelHandler handler() {
        return this.ctx.handler();
    }

    @Override
    public boolean isRemoved() {
        return this.removed || this.ctx.isRemoved();
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        this.ctx.fireChannelRegistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        this.ctx.fireChannelUnregistered();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        this.ctx.fireChannelActive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        this.ctx.fireChannelInactive();
        return this;
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        this.ctx.fireExceptionCaught(throwable);
        return this;
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        this.ctx.fireUserEventTriggered(object);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        this.ctx.fireChannelRead(object);
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        this.ctx.fireChannelReadComplete();
        return this;
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        this.ctx.fireChannelWritabilityChanged();
        return this;
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.ctx.bind(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.ctx.connect(socketAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.ctx.connect(socketAddress, socketAddress2);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.ctx.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.ctx.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.ctx.deregister();
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.ctx.bind(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.ctx.connect(socketAddress, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        return this.ctx.connect(socketAddress, socketAddress2, channelPromise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        return this.ctx.disconnect(channelPromise);
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        return this.ctx.close(channelPromise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        return this.ctx.deregister(channelPromise);
    }

    @Override
    public ChannelHandlerContext read() {
        this.ctx.read();
        return this;
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.ctx.write(object);
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        return this.ctx.write(object, channelPromise);
    }

    @Override
    public ChannelHandlerContext flush() {
        this.ctx.flush();
        return this;
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        return this.ctx.writeAndFlush(object, channelPromise);
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.ctx.writeAndFlush(object);
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.ctx.pipeline();
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.ctx.alloc();
    }

    @Override
    public ChannelPromise newPromise() {
        return this.ctx.newPromise();
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return this.ctx.newProgressivePromise();
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.ctx.newSucceededFuture();
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return this.ctx.newFailedFuture(throwable);
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.ctx.voidPromise();
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.ctx.channel().attr(attributeKey);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        return this.ctx.channel().hasAttr(attributeKey);
    }

    final void remove() {
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor.inEventLoop()) {
            this.remove0();
        } else {
            eventExecutor.execute(new CombinedChannelDuplexHandler$DelegatingChannelHandlerContext$1(this));
        }
    }

    private void remove0() {
        if (!this.removed) {
            this.removed = true;
            try {
                this.handler.handlerRemoved(this);
            }
            catch (Throwable throwable) {
                this.fireExceptionCaught(new ChannelPipelineException(this.handler.getClass().getName() + ".handlerRemoved() has thrown an exception.", throwable));
            }
        }
    }

    static /* synthetic */ ChannelHandlerContext access$300(CombinedChannelDuplexHandler$DelegatingChannelHandlerContext combinedChannelDuplexHandler$DelegatingChannelHandlerContext) {
        return combinedChannelDuplexHandler$DelegatingChannelHandlerContext.ctx;
    }

    static /* synthetic */ void access$400(CombinedChannelDuplexHandler$DelegatingChannelHandlerContext combinedChannelDuplexHandler$DelegatingChannelHandlerContext) {
        combinedChannelDuplexHandler$DelegatingChannelHandlerContext.remove0();
    }
}

